package io.qt.sql;

import io.qt.*;


/**
 * <p>The base class for SQL driver factories</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qsqldrivercreatorbase.html">QSqlDriverCreatorBase</a></p>
 */
public abstract class QSqlDriverCreatorBase extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @NativeAccess
    private static final class ConcreteWrapper extends QSqlDriverCreatorBase {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public io.qt.sql.@Nullable QSqlDriver createObject(){
            return createObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native io.qt.sql.QSqlDriver createObject_native_constfct(long __this__nativeId);
        
    }
    
    
    public QSqlDriverCreatorBase(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSqlDriverCreatorBase instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqldrivercreatorbase.html#createObject">QSqlDriverCreatorBase::createObject()const</a></p>
     */
    @QtUninvokable
    public abstract io.qt.sql.@Nullable QSqlDriver createObject();
    
    @QtUninvokable
    private native io.qt.sql.QSqlDriver createObject_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSqlDriverCreatorBase(QPrivateConstructor p) { super(p); } 
    
}
