package io.qt.sql;

import io.qt.*;


/**
 * <p>Contains miscellaneous identifiers used throughout the Qt SQL module</p>
 * <p>Java wrapper for Qt's namespace <a href="http://doc.qt.io/qt-5/qsql.html">QSql</a></p>
 */
public final class QSql
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QSql() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QSql."); }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsql.html#Location-enum">QSql::Location</a></p>
     */
    public enum Location implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qsql.html#Location-enum">QSql::BeforeFirstRow</a></p>
         */
        BeforeFirstRow(-1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qsql.html#Location-enum">QSql::AfterLastRow</a></p>
         */
        AfterLastRow(-2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Location(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Location resolve(int value) {
            switch (value) {
            case -1: return BeforeFirstRow;
            case -2: return AfterLastRow;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsql.html#NumericalPrecisionPolicy-enum">QSql::NumericalPrecisionPolicy</a></p>
     */
    public enum NumericalPrecisionPolicy implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qsql.html#NumericalPrecisionPolicy-enum">QSql::LowPrecisionInt32</a></p>
         */
        LowPrecisionInt32(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qsql.html#NumericalPrecisionPolicy-enum">QSql::LowPrecisionInt64</a></p>
         */
        LowPrecisionInt64(2),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qsql.html#NumericalPrecisionPolicy-enum">QSql::LowPrecisionDouble</a></p>
         */
        LowPrecisionDouble(4),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qsql.html#NumericalPrecisionPolicy-enum">QSql::HighPrecision</a></p>
         */
        HighPrecision(0);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private NumericalPrecisionPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull NumericalPrecisionPolicy resolve(int value) {
            switch (value) {
            case 1: return LowPrecisionInt32;
            case 2: return LowPrecisionInt64;
            case 4: return LowPrecisionDouble;
            case 0: return HighPrecision;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsql.html#ParamTypeFlag-enum">QSql::ParamTypeFlag</a></p>
     * 
     * @see ParamType
     */
    public enum ParamTypeFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qsql.html#ParamTypeFlag-enum">QSql::In</a></p>
         */
        In(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qsql.html#ParamTypeFlag-enum">QSql::Out</a></p>
         */
        Out(2),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qsql.html#ParamTypeFlag-enum">QSql::InOut</a></p>
         */
        InOut(3),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qsql.html#ParamTypeFlag-enum">QSql::Binary</a></p>
         */
        Binary(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ParamTypeFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull ParamType asFlags() {
            return new ParamType(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ParamType combined(@NonNull ParamTypeFlag e) {
            return new ParamType(this, e);
        }

        /**
         * Creates a new {@link ParamType} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull ParamType flags(@Nullable ParamTypeFlag @NonNull... values) {
            return new ParamType(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ParamTypeFlag resolve(int value) {
            switch (value) {
            case 1: return In;
            case 2: return Out;
            case 3: return InOut;
            case 4: return Binary;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link ParamTypeFlag}
     */
    public static final class ParamType extends QFlags<ParamTypeFlag> implements Comparable<ParamType> {
        private static final long serialVersionUID = 0x53e415e7b2e0668eL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new ParamType where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ParamType(@Nullable ParamTypeFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new ParamType with given <code>value</code>.
         * @param value
         */
        public ParamType(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ParamType
         */
        @Override
        public final @NonNull ParamType combined(@StrictNonNull ParamTypeFlag e){
            return new ParamType(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull ParamType setFlag(@Nullable ParamTypeFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull ParamType setFlag(@Nullable ParamTypeFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ParamType.
         * @return array of enum entries
         */
        @Override
        public final @NonNull ParamTypeFlag @NonNull[] flags(){
            return super.flags(ParamTypeFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull ParamType clone(){
            return new ParamType(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull ParamType other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsql.html#TableType-enum">QSql::TableType</a></p>
     */
    public enum TableType implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qsql.html#TableType-enum">QSql::Tables</a></p>
         */
        Tables(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qsql.html#TableType-enum">QSql::SystemTables</a></p>
         */
        SystemTables(2),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qsql.html#TableType-enum">QSql::Views</a></p>
         */
        Views(4),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qsql.html#TableType-enum">QSql::AllTables</a></p>
         */
        AllTables(255);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TableType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TableType resolve(int value) {
            switch (value) {
            case 1: return Tables;
            case 2: return SystemTables;
            case 4: return Views;
            case 255: return AllTables;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
}
