#include "QSqlDatabase_shell.h"
#include <QtJambi/Cast>

void deleter_QSqlDatabase(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QSqlDatabase")
    QSqlDatabase *_ptr = reinterpret_cast<QSqlDatabase *>(ptr);
    if(isShell){
        delete static_cast<QSqlDatabase_shell*>(_ptr);
    }else{
        QtJambiAPI::registerNonShellDeletion(ptr);
        delete _ptr;
    }
}

QtJambiShell* QSqlDatabase_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QSqlDatabase_shell) ); }

jmethodID QSqlDatabase_shell::__shell_javaMethod(int pos) const { return QSqlDatabase_shell::__shell()->javaMethod(typeid(QSqlDatabase), pos); }

// emitting (writeShellConstructor)
QSqlDatabase_shell::QSqlDatabase_shell()
    : QSqlDatabase()
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QSqlDatabase::QSqlDatabase_shell()", QSqlDatabase_shell::__shell())
    QSqlDatabase_shell::__shell()->constructed(typeid(QSqlDatabase));
}

QSqlDatabase_shell::QSqlDatabase_shell(QSqlDriver* driver0)
    : QSqlDatabase(driver0)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QSqlDatabase::QSqlDatabase_shell(QSqlDriver* driver0)", QSqlDatabase_shell::__shell())
    QSqlDatabase_shell::__shell()->constructed(typeid(QSqlDatabase));
}

QSqlDatabase_shell::QSqlDatabase_shell(const QSqlDatabase& other0)
    : QSqlDatabase(other0)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QSqlDatabase::QSqlDatabase_shell(const QSqlDatabase& other0)", QSqlDatabase_shell::__shell())
    QSqlDatabase_shell::__shell()->constructed(typeid(QSqlDatabase));
}

QSqlDatabase_shell::QSqlDatabase_shell(const QString& type0)
    : QSqlDatabase(type0)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QSqlDatabase::QSqlDatabase_shell(const QString& type0)", QSqlDatabase_shell::__shell())
    QSqlDatabase_shell::__shell()->constructed(typeid(QSqlDatabase));
}

// emitting (writeShellDestructor)
QSqlDatabase_shell::~QSqlDatabase_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QSqlDatabase::~QSqlDatabase()", QSqlDatabase_shell::__shell())
    QSqlDatabase_shell::__shell()->destructed(typeid(QSqlDatabase));
}

void QSqlDatabase_shell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QSqlDatabase_shell*>(ptr)->QSqlDatabase_shell::__shell()->tryDeleteShell(typeid(QSqlDatabase));
}

// emitting Virtual overrides (virtualFunctions)
// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
// emitting (writeConstructors)
// new QSqlDatabase()
void __qt_construct_QSqlDatabase_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSqlDatabase()")
    Q_UNUSED(__java_arguments)
    QSqlDatabase *__qt_this = new(__qtjambi_ptr) QSqlDatabase_shell();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QSqlDatabase(QSqlDriver*)
void __qt_construct_QSqlDatabase_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSqlDatabase(QSqlDriver*)")
    jobject driver0 = __java_arguments[0].l;
    QSqlDriver* __qt_driver0 = qtjambi_cast<QSqlDriver* >(__jni_env, driver0);
    QSqlDatabase *__qt_this = new(__qtjambi_ptr) QSqlDatabase_shell(__qt_driver0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QSqlDatabase(QSqlDatabase)
void __qt_construct_QSqlDatabase_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSqlDatabase(QSqlDatabase)")
    jobject other0 = __java_arguments[0].l;
    const QSqlDatabase& __qt_other0 = qtjambi_cast<const QSqlDatabase& >(__jni_env, other0);
    QSqlDatabase *__qt_this = new(__qtjambi_ptr) QSqlDatabase_shell(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QSqlDatabase(QString)
void __qt_construct_QSqlDatabase_3(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSqlDatabase(QString)")
    jstring type0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_type0 = qtjambi_cast<QString>(__jni_env, type0);
    QSqlDatabase *__qt_this = new(__qtjambi_ptr) QSqlDatabase_shell(__qt_type0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QSqlDatabase_shell
void __qt_destruct_QSqlDatabase(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QSqlDatabase")
    reinterpret_cast<QSqlDatabase_shell*>(ptr)->~QSqlDatabase_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QSqlDatabase::QSqlDatabase()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_initialize_1native__Lio_qt_sql_QSqlDatabase_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::QSqlDatabase()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSqlDatabase_0, sizeof(QSqlDatabase_shell), typeid(QSqlDatabase), true, &deleter_QSqlDatabase, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSqlDatabase::QSqlDatabase(QSqlDriver*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_initialize_1native__Lio_qt_sql_QSqlDatabase_2Lio_qt_sql_QSqlDriver_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject driver0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::QSqlDatabase(QSqlDriver*)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = driver0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSqlDatabase_1, sizeof(QSqlDatabase_shell), typeid(QSqlDatabase), true, &deleter_QSqlDatabase, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSqlDatabase::QSqlDatabase(QSqlDatabase)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_initialize_1native__Lio_qt_sql_QSqlDatabase_2Lio_qt_sql_QSqlDatabase_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::QSqlDatabase(QSqlDatabase)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSqlDatabase_2, sizeof(QSqlDatabase_shell), typeid(QSqlDatabase), true, &deleter_QSqlDatabase, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSqlDatabase::QSqlDatabase(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_initialize_1native__Lio_qt_sql_QSqlDatabase_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring type0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::QSqlDatabase(QString)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = type0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSqlDatabase_3, sizeof(QSqlDatabase_shell), typeid(QSqlDatabase), true, &deleter_QSqlDatabase, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSqlDatabase::close()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_close_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::close()", __qt_this)
        __qt_this->close();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSqlDatabase::commit()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_commit_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::commit()", __qt_this)
        __java_return_value = __qt_this->commit();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::connectOptions()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_connectOptions_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::connectOptions()const", __qt_this)
        QString __qt_return_value = __qt_this->connectOptions();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::connectionName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_connectionName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::connectionName()const", __qt_this)
        QString __qt_return_value = __qt_this->connectionName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::databaseName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_databaseName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::databaseName()const", __qt_this)
        QString __qt_return_value = __qt_this->databaseName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::driver()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_driver_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::driver()const", __qt_this)
        QSqlDriver* __qt_return_value = __qt_this->driver();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::driverName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_driverName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::driverName()const", __qt_this)
        QString __qt_return_value = __qt_this->driverName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::exec(QString)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_exec_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring query0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::exec(QString)const", __qt_this)
        QString  __qt_query0 = qtjambi_cast<QString>(__jni_env, query0);
        QSqlQuery __qt_return_value = __qt_this->exec(__qt_query0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::hostName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_hostName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::hostName()const", __qt_this)
        QString __qt_return_value = __qt_this->hostName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::isOpen()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_isOpen_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::isOpen()const", __qt_this)
        __java_return_value = __qt_this->isOpen();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::isOpenError()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_isOpenError_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::isOpenError()const", __qt_this)
        __java_return_value = __qt_this->isOpenError();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::lastError()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_lastError_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::lastError()const", __qt_this)
        QSqlError __qt_return_value = __qt_this->lastError();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::numericalPrecisionPolicy()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_numericalPrecisionPolicy_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::numericalPrecisionPolicy()const", __qt_this)
        QSql::NumericalPrecisionPolicy __qt_return_value = __qt_this->numericalPrecisionPolicy();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::open()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_open_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::open()", __qt_this)
        __java_return_value = __qt_this->open();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::open(QString,QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_open_1native_1cref_1QString_1cref_1QString__JLjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring user0,
 jstring password1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::open(QString,QString)", __qt_this)
        QString  __qt_user0 = qtjambi_cast<QString>(__jni_env, user0);
        QString  __qt_password1 = qtjambi_cast<QString>(__jni_env, password1);
        __java_return_value = __qt_this->open(__qt_user0, __qt_password1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::operator=(QSqlDatabase)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_assign_1native_1cref_1QSqlDatabase__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::operator=(QSqlDatabase)", __qt_this)
        const QSqlDatabase& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QSqlDatabase>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSqlDatabase::password()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_password_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::password()const", __qt_this)
        QString __qt_return_value = __qt_this->password();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::port()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_port_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::port()const", __qt_this)
        __java_return_value = __qt_this->port();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::primaryIndex(QString)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_primaryIndex_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring tablename0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::primaryIndex(QString)const", __qt_this)
        QString  __qt_tablename0 = qtjambi_cast<QString>(__jni_env, tablename0);
        QSqlIndex __qt_return_value = __qt_this->primaryIndex(__qt_tablename0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::record(QString)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_record_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring tablename0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::record(QString)const", __qt_this)
        QString  __qt_tablename0 = qtjambi_cast<QString>(__jni_env, tablename0);
        QSqlRecord __qt_return_value = __qt_this->record(__qt_tablename0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::rollback()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_rollback_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::rollback()", __qt_this)
        __java_return_value = __qt_this->rollback();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::setConnectOptions(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_setConnectOptions_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring options0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::setConnectOptions(QString)", __qt_this)
        QString  __qt_options0 = qtjambi_cast<QString>(__jni_env, options0);
        __qt_this->setConnectOptions(__qt_options0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSqlDatabase::setDatabaseName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_setDatabaseName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::setDatabaseName(QString)", __qt_this)
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        __qt_this->setDatabaseName(__qt_name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSqlDatabase::setHostName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_setHostName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring host0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::setHostName(QString)", __qt_this)
        QString  __qt_host0 = qtjambi_cast<QString>(__jni_env, host0);
        __qt_this->setHostName(__qt_host0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSqlDatabase::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_setNumericalPrecisionPolicy_1native_1QSql_1NumericalPrecisionPolicy__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint precisionPolicy0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)", __qt_this)
        QSql::NumericalPrecisionPolicy __qt_precisionPolicy0 = qtjambi_cast<QSql::NumericalPrecisionPolicy>(__jni_env, precisionPolicy0);
        __qt_this->setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy(__qt_precisionPolicy0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSqlDatabase::setPassword(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_setPassword_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring password0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::setPassword(QString)", __qt_this)
        QString  __qt_password0 = qtjambi_cast<QString>(__jni_env, password0);
        __qt_this->setPassword(__qt_password0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSqlDatabase::setPort(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_setPort_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::setPort(int)", __qt_this)
        __qt_this->setPort(static_cast<int>(p0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSqlDatabase::setUserName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_setUserName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::setUserName(QString)", __qt_this)
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        __qt_this->setUserName(__qt_name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSqlDatabase::tables(QSql::TableType)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_tables_1native_1QSql_1TableType_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint type0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::tables(QSql::TableType)const", __qt_this)
        QSql::TableType __qt_type0 = qtjambi_cast<QSql::TableType>(__jni_env, type0);
        QStringList __qt_return_value = __qt_this->tables(QSql::TableType(__qt_type0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::transaction()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_transaction_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::transaction()", __qt_this)
        __java_return_value = __qt_this->transaction();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::userName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_userName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSqlDatabase::userName()const", __qt_this)
        QString __qt_return_value = __qt_this->userName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::addDatabase(QSqlDriver*,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_addDatabase_1native_1QSqlDriver_1ptr_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID driver0,
 jstring connectionName1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::addDatabase(QSqlDriver*,QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QSqlDriver* __qt_driver0 = QtJambiAPI::objectFromNativeId<QSqlDriver>(driver0);
        QtJambiAPI::setCppOwnershipForTopLevelObject(__jni_env, __qt_driver0);
        QString  __qt_connectionName1 = qtjambi_cast<QString>(__jni_env, connectionName1);
        QSqlDatabase __qt_return_value = QSqlDatabase::addDatabase(__qt_driver0, __qt_connectionName1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::addDatabase(QString,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_addDatabase__Ljava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring type0,
 jstring connectionName1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::addDatabase(QString,QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_type0 = qtjambi_cast<QString>(__jni_env, type0);
        QString  __qt_connectionName1 = qtjambi_cast<QString>(__jni_env, connectionName1);
        QSqlDatabase __qt_return_value = QSqlDatabase::addDatabase(__qt_type0, __qt_connectionName1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::cloneDatabase(QSqlDatabase,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_cloneDatabase_1native_1cref_1QSqlDatabase_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID other0,
 jstring connectionName1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::cloneDatabase(QSqlDatabase,QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSqlDatabase& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QSqlDatabase>(other0);
        QString  __qt_connectionName1 = qtjambi_cast<QString>(__jni_env, connectionName1);
        QSqlDatabase __qt_return_value = QSqlDatabase::cloneDatabase(__qt_other0, __qt_connectionName1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::cloneDatabase(QString,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_cloneDatabase__Ljava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring other0,
 jstring connectionName1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::cloneDatabase(QString,QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_other0 = qtjambi_cast<QString>(__jni_env, other0);
        QString  __qt_connectionName1 = qtjambi_cast<QString>(__jni_env, connectionName1);
        QSqlDatabase __qt_return_value = QSqlDatabase::cloneDatabase(__qt_other0, __qt_connectionName1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::connectionNames()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_connectionNames__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::connectionNames()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QStringList __qt_return_value = QSqlDatabase::connectionNames();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::contains(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_contains__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring connectionName0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::contains(QString)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_connectionName0 = qtjambi_cast<QString>(__jni_env, connectionName0);
        __java_return_value = QSqlDatabase::contains(__qt_connectionName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::database(QString,bool)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_database__Ljava_lang_String_2Z)
(JNIEnv *__jni_env,
 jclass,
 jstring connectionName0,
 jboolean open1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::database(QString,bool)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_connectionName0 = qtjambi_cast<QString>(__jni_env, connectionName0);
        QSqlDatabase __qt_return_value = QSqlDatabase::database(__qt_connectionName0, static_cast<bool>(open1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::drivers()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_drivers__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::drivers()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QStringList __qt_return_value = QSqlDatabase::drivers();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::isDriverAvailable(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_isDriverAvailable__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring name0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::isDriverAvailable(QString)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        __java_return_value = QSqlDatabase::isDriverAvailable(__qt_name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSqlDatabase::registerSqlDriver(QString,QSqlDriverCreatorBase*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_registerSqlDriver_1native_1cref_1QString_1QSqlDriverCreatorBase_1ptr__Ljava_lang_String_2J)
(JNIEnv *__jni_env,
 jclass,
 jstring name0,
 QtJambiNativeID creator1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::registerSqlDriver(QString,QSqlDriverCreatorBase*)")
    QTJAMBI_TRY {
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        QSqlDriverCreatorBase* __qt_creator1 = QtJambiAPI::objectFromNativeId<QSqlDriverCreatorBase>(creator1);
        QtJambiAPI::setCppOwnership(__jni_env, creator1);
        QSqlDatabase::registerSqlDriver(__qt_name0, __qt_creator1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSqlDatabase::removeDatabase(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_removeDatabase__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring connectionName0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSqlDatabase::removeDatabase(QString)")
    QTJAMBI_TRY {
        QString  __qt_connectionName0 = qtjambi_cast<QString>(__jni_env, connectionName0);
        QSqlDatabase::removeDatabase(__qt_connectionName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting Field accessors (writeFieldAccessors)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_setDefaultConnection__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring defaultConnection0)
{
    QtJambiScope __qtjambi_scope;
    QTJAMBI_TRY {
        const char*  __qt_defaultConnection0 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, defaultConnection0);
        QSqlDatabase_shell::defaultConnection = __qt_defaultConnection0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
}

extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_defaultConnection__)
(JNIEnv *__jni_env,
 jclass)
{
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const char*  __qt_value = QSqlDatabase_shell::defaultConnection;
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeJavaLangObjectOverrideFunctions)

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_sql_QSqlDatabase_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QSqlDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QSqlDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QSqlDatabase(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QSqlDatabase>("QSqlDatabase", "io/qt/sql/QSqlDatabase");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QSqlDatabase, {
        ConstructorInfo(&__qt_construct_QSqlDatabase_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QSqlDatabase_1, "Lio/qt/sql/QSqlDriver;")
       ,ConstructorInfo(&__qt_construct_QSqlDatabase_2, "Lio/qt/sql/QSqlDatabase;")
       ,ConstructorInfo(&__qt_construct_QSqlDatabase_3, "Ljava/lang/String;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QSqlDatabase);
    registerMetaType<QSqlDatabase>("QSqlDatabase");
    registerSizeOfShell(typeId, sizeof(QSqlDatabase_shell));
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
