package io.qt.spatialaudio;

import io.qt.*;


/**
 * <p>Manages a three dimensional sound field</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaudioengine.html">QAudioEngine</a></code></p>
 */
public class QAudioEngine extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAudioEngine.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qaudioengine.html#OutputMode-enum">QAudioEngine::OutputMode</a></code></p>
     */
    public enum OutputMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioengine.html#OutputMode-enum">QAudioEngine::<wbr/>Surround</a></code></p>
         */
        Surround(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioengine.html#OutputMode-enum">QAudioEngine::<wbr/>Stereo</a></code></p>
         */
        Stereo(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioengine.html#OutputMode-enum">QAudioEngine::<wbr/>Headphone</a></code></p>
         */
        Headphone(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private OutputMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull OutputMode resolve(int value) {
            switch (value) {
            case 0: return Surround;
            case 1: return Stereo;
            case 2: return Headphone;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#distanceScale-prop">QAudioEngine::<wbr/>distanceScaleChanged()</a></code></p>
     */
    @QtPropertyNotify(name="distanceScale")
    public final @NonNull Signal0 distanceScaleChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#masterVolume-prop">QAudioEngine::<wbr/>masterVolumeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="masterVolume")
    public final @NonNull Signal0 masterVolumeChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#outputDevice-prop">QAudioEngine::<wbr/>outputDeviceChanged()</a></code></p>
     */
    @QtPropertyNotify(name="outputDevice")
    public final @NonNull Signal0 outputDeviceChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#outputMode-prop">QAudioEngine::<wbr/>outputModeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="outputMode")
    public final @NonNull Signal0 outputModeChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#paused-prop">QAudioEngine::<wbr/>pausedChanged()</a></code></p>
     */
    @QtPropertyNotify(name="paused")
    public final @NonNull Signal0 pausedChanged = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#QAudioEngine">QAudioEngine::<wbr/>QAudioEngine()</a></code></p>
     */
    public QAudioEngine(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QAudioEngine instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#QAudioEngine-1">QAudioEngine::<wbr/>QAudioEngine(QObject*)</a></code></p>
     */
    public QAudioEngine(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAudioEngine instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#QAudioEngine-2">QAudioEngine::<wbr/>QAudioEngine(int,<wbr/>QObject*)</a></code></p>
     */
    public QAudioEngine(int sampleRate, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, sampleRate, parent);
    }
    
    private native static void initialize_native(QAudioEngine instance, int sampleRate, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#distanceScale-prop">QAudioEngine::<wbr/>distanceScale()const</a></code></p>
     */
    @QtPropertyReader(name="distanceScale")
    @QtUninvokable
    public final float distanceScale(){
        return distanceScale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float distanceScale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#masterVolume-prop">QAudioEngine::<wbr/>masterVolume()const</a></code></p>
     */
    @QtPropertyReader(name="masterVolume")
    @QtUninvokable
    public final float masterVolume(){
        return masterVolume_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float masterVolume_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#outputDevice-prop">QAudioEngine::<wbr/>outputDevice()const</a></code></p>
     */
    @QtPropertyReader(name="outputDevice")
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QAudioDevice outputDevice(){
        return outputDevice_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QAudioDevice outputDevice_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#outputMode-prop">QAudioEngine::<wbr/>outputMode()const</a></code></p>
     */
    @QtPropertyReader(name="outputMode")
    @QtUninvokable
    public final io.qt.spatialaudio.QAudioEngine.@NonNull OutputMode outputMode(){
        return io.qt.spatialaudio.QAudioEngine.OutputMode.resolve(outputMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int outputMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#pause">QAudioEngine::<wbr/>pause()</a></code></p>
     */
    public final void pause(){
        pause_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void pause_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#paused-prop">QAudioEngine::<wbr/>paused()const</a></code></p>
     */
    @QtPropertyReader(name="paused")
    @QtUninvokable
    public final boolean paused(){
        return paused_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean paused_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#resume">QAudioEngine::<wbr/>resume()</a></code></p>
     */
    public final void resume(){
        resume_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void resume_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#roomEffectsEnabled">QAudioEngine::<wbr/>roomEffectsEnabled()const</a></code></p>
     */
    @QtUninvokable
    public final boolean roomEffectsEnabled(){
        return roomEffectsEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean roomEffectsEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#sampleRate">QAudioEngine::<wbr/>sampleRate()const</a></code></p>
     */
    @QtUninvokable
    public final int sampleRate(){
        return sampleRate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int sampleRate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#distanceScale-prop">QAudioEngine::<wbr/>setDistanceScale(float)</a></code></p>
     */
    @QtPropertyWriter(name="distanceScale")
    @QtUninvokable
    public final void setDistanceScale(float scale){
        setDistanceScale_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), scale);
    }
    
    @QtUninvokable
    private native void setDistanceScale_native_float(long __this__nativeId, float scale);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#masterVolume-prop">QAudioEngine::<wbr/>setMasterVolume(float)</a></code></p>
     */
    @QtPropertyWriter(name="masterVolume")
    @QtUninvokable
    public final void setMasterVolume(float volume){
        setMasterVolume_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), volume);
    }
    
    @QtUninvokable
    private native void setMasterVolume_native_float(long __this__nativeId, float volume);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#outputDevice-prop">QAudioEngine::<wbr/>setOutputDevice(QAudioDevice)</a></code></p>
     */
    @QtPropertyWriter(name="outputDevice")
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setOutputDevice(io.qt.multimedia.@NonNull QAudioDevice device){
        setOutputDevice_native_cref_QAudioDevice(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(device));
    }
    
    @QtUninvokable
    private native void setOutputDevice_native_cref_QAudioDevice(long __this__nativeId, long device);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#outputMode-prop">QAudioEngine::<wbr/>setOutputMode(QAudioEngine::OutputMode)</a></code></p>
     */
    @QtPropertyWriter(name="outputMode")
    @QtUninvokable
    public final void setOutputMode(io.qt.spatialaudio.QAudioEngine.@NonNull OutputMode mode){
        setOutputMode_native_QAudioEngine_OutputMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @QtUninvokable
    private native void setOutputMode_native_QAudioEngine_OutputMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#paused-prop">QAudioEngine::<wbr/>setPaused(bool)</a></code></p>
     */
    @QtPropertyWriter(name="paused")
    @QtUninvokable
    public final void setPaused(boolean paused){
        setPaused_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), paused);
    }
    
    @QtUninvokable
    private native void setPaused_native_bool(long __this__nativeId, boolean paused);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#setRoomEffectsEnabled">QAudioEngine::<wbr/>setRoomEffectsEnabled(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setRoomEffectsEnabled(boolean enabled){
        setRoomEffectsEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setRoomEffectsEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#start">QAudioEngine::<wbr/>start()</a></code></p>
     */
    public final void start(){
        start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void start_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioengine.html#stop">QAudioEngine::<wbr/>stop()</a></code></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAudioEngine(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAudioEngine(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAudioEngine instance, QDeclarativeConstructor constructor);
    
    public static final float DistanceScaleCentimeter = 1.f;
    public static final float DistanceScaleMeter = 100.f;
    
    /**
     * <p>Overloaded constructor for {@link #QAudioEngine(int, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAudioEngine(int sampleRate) {
        this(sampleRate, (io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #distanceScale()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDistanceScale() {
        return distanceScale();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #masterVolume()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMasterVolume() {
        return masterVolume();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #outputDevice()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QAudioDevice getOutputDevice() {
        return outputDevice();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #outputMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.spatialaudio.QAudioEngine.@NonNull OutputMode getOutputMode() {
        return outputMode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #paused()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getPaused() {
        return paused();
    }
}
