package io.qt.spatialaudio;

import io.qt.*;


/**
 * <p>Defines the position and orientation of the person listening to a sound field defined by QAudioEngine</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaudiolistener.html">QAudioListener</a></code></p>
 */
public class QAudioListener extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiolistener.html#QAudioListener">QAudioListener::<wbr>QAudioListener(QAudioEngine*)</a></code></p>
     */
    public QAudioListener(io.qt.spatialaudio.@Nullable QAudioEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, engine);
    }
    
    private native static void initialize_native(QAudioListener instance, io.qt.spatialaudio.QAudioEngine engine);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiolistener.html#engine">QAudioListener::<wbr>engine()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.spatialaudio.@Nullable QAudioEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.spatialaudio.QAudioEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiolistener.html#position">QAudioListener::<wbr>position()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiolistener.html#rotation">QAudioListener::<wbr>rotation()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiolistener.html#setPosition">QAudioListener::<wbr>setPosition(QVector3D)</a></code></p>
     */
    @QtUninvokable
    public final void setPosition(io.qt.gui.@NonNull QVector3D pos){
        setPosition_native_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pos));
    }
    
    @QtUninvokable
    private native void setPosition_native_QVector3D(long __this__nativeId, long pos);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiolistener.html#setRotation">QAudioListener::<wbr>setRotation(QQuaternion)</a></code></p>
     */
    @QtUninvokable
    public final void setRotation(io.qt.gui.@NonNull QQuaternion q){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(q));
    }
    
    @QtUninvokable
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long q);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAudioListener(QPrivateConstructor p) { super(p); } 
    
}
