package io.qt.spatialaudio;

import io.qt.*;


/**
 * <p>A stereo overlay sound</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qambientsound.html">QAmbientSound</a></code></p>
 */
public class QAmbientSound extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAmbientSound.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qambientsound.html#Loops-enum">QAmbientSound::Loops</a></code></p>
     */
    public enum Loops implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qambientsound.html#Loops-enum">QAmbientSound::<wbr/>Infinite</a></code></p>
         */
        Infinite(-1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qambientsound.html#Loops-enum">QAmbientSound::<wbr/>Once</a></code></p>
         */
        Once(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Loops(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Loops resolve(int value) {
            switch (value) {
            case -1: return Infinite;
            case 1: return Once;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#autoPlay-prop">QAmbientSound::<wbr/>autoPlayChanged()</a></code></p>
     */
    @QtPropertyNotify(name="autoPlay")
    public final @NonNull Signal0 autoPlayChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#loops-prop">QAmbientSound::<wbr/>loopsChanged()</a></code></p>
     */
    @QtPropertyNotify(name="loops")
    public final @NonNull Signal0 loopsChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#source-prop">QAmbientSound::<wbr/>sourceChanged()</a></code></p>
     */
    @QtPropertyNotify(name="source")
    public final @NonNull Signal0 sourceChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#volume-prop">QAmbientSound::<wbr/>volumeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="volume")
    public final @NonNull Signal0 volumeChanged = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#QAmbientSound">QAmbientSound::<wbr/>QAmbientSound(QAudioEngine*)</a></code></p>
     */
    public QAmbientSound(io.qt.spatialaudio.@Nullable QAudioEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, engine);
    }
    
    private native static void initialize_native(QAmbientSound instance, io.qt.spatialaudio.QAudioEngine engine);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#autoPlay-prop">QAmbientSound::<wbr/>autoPlay()const</a></code></p>
     */
    @QtPropertyReader(name="autoPlay")
    @QtUninvokable
    public final boolean autoPlay(){
        return autoPlay_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoPlay_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#engine">QAmbientSound::<wbr/>engine()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.spatialaudio.@Nullable QAudioEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.spatialaudio.QAudioEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#loops-prop">QAmbientSound::<wbr/>loops()const</a></code></p>
     */
    @QtPropertyReader(name="loops")
    @QtUninvokable
    public final int loops(){
        return loops_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int loops_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#pause">QAmbientSound::<wbr/>pause()</a></code></p>
     */
    public final void pause(){
        pause_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void pause_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#play">QAmbientSound::<wbr/>play()</a></code></p>
     */
    public final void play(){
        play_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void play_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#autoPlay-prop">QAmbientSound::<wbr/>setAutoPlay(bool)</a></code></p>
     */
    @QtPropertyWriter(name="autoPlay")
    @QtUninvokable
    public final void setAutoPlay(boolean autoPlay){
        setAutoPlay_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), autoPlay);
    }
    
    @QtUninvokable
    private native void setAutoPlay_native_bool(long __this__nativeId, boolean autoPlay);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#loops-prop">QAmbientSound::<wbr/>setLoops(int)</a></code></p>
     */
    @QtPropertyWriter(name="loops")
    @QtUninvokable
    public final void setLoops(int loops){
        setLoops_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), loops);
    }
    
    @QtUninvokable
    private native void setLoops_native_int(long __this__nativeId, int loops);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#source-prop">QAmbientSound::<wbr/>setSource(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="source")
    @QtUninvokable
    public final void setSource(io.qt.core.@NonNull QUrl url){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setSource_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#volume-prop">QAmbientSound::<wbr/>setVolume(float)</a></code></p>
     */
    @QtPropertyWriter(name="volume")
    @QtUninvokable
    public final void setVolume(float volume){
        setVolume_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), volume);
    }
    
    @QtUninvokable
    private native void setVolume_native_float(long __this__nativeId, float volume);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#source-prop">QAmbientSound::<wbr/>source()const</a></code></p>
     */
    @QtPropertyReader(name="source")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#stop">QAmbientSound::<wbr/>stop()</a></code></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientsound.html#volume-prop">QAmbientSound::<wbr/>volume()const</a></code></p>
     */
    @QtPropertyReader(name="volume")
    @QtUninvokable
    public final float volume(){
        return volume_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float volume_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAmbientSound(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #autoPlay()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoPlay() {
        return autoPlay();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #loops()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getLoops() {
        return loops();
    }
    
    /**
     * <p>Overloaded function for {@link #setSource(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setSource(java.lang.@NonNull String url) {
        setSource(new io.qt.core.QUrl(url));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #source()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getSource() {
        return source();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #volume()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getVolume() {
        return volume();
    }
}
