package io.qt.spatialaudio;

import io.qt.*;


/**
 * <p>A sound object in 3D space</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qspatialsound.html">QSpatialSound</a></code></p>
 */
public class QSpatialSound extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSpatialSound.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qspatialsound.html#DistanceModel-enum">QSpatialSound::DistanceModel</a></code></p>
     */
    public enum DistanceModel implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qspatialsound.html#DistanceModel-enum">QSpatialSound::<wbr/>DistanceModel::<wbr/>Logarithmic</a></code></p>
         */
        Logarithmic(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qspatialsound.html#DistanceModel-enum">QSpatialSound::<wbr/>DistanceModel::<wbr/>Linear</a></code></p>
         */
        Linear(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qspatialsound.html#DistanceModel-enum">QSpatialSound::<wbr/>DistanceModel::<wbr/>ManualAttenuation</a></code></p>
         */
        ManualAttenuation(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DistanceModel(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DistanceModel resolve(int value) {
            switch (value) {
            case 0: return Logarithmic;
            case 1: return Linear;
            case 2: return ManualAttenuation;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qspatialsound.html#Loops-enum">QSpatialSound::Loops</a></code></p>
     */
    public enum Loops implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qspatialsound.html#Loops-enum">QSpatialSound::<wbr/>Infinite</a></code></p>
         */
        Infinite(-1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qspatialsound.html#Loops-enum">QSpatialSound::<wbr/>Once</a></code></p>
         */
        Once(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Loops(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Loops resolve(int value) {
            switch (value) {
            case -1: return Infinite;
            case 1: return Once;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#autoPlay-prop">QSpatialSound::<wbr/>autoPlayChanged()</a></code></p>
     */
    @QtPropertyNotify(name="autoPlay")
    public final @NonNull Signal0 autoPlayChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#directivity-prop">QSpatialSound::<wbr/>directivityChanged()</a></code></p>
     */
    @QtPropertyNotify(name="directivity")
    public final @NonNull Signal0 directivityChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#directivityOrder-prop">QSpatialSound::<wbr/>directivityOrderChanged()</a></code></p>
     */
    @QtPropertyNotify(name="directivityOrder")
    public final @NonNull Signal0 directivityOrderChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#distanceCutoff-prop">QSpatialSound::<wbr/>distanceCutoffChanged()</a></code></p>
     */
    @QtPropertyNotify(name="distanceCutoff")
    public final @NonNull Signal0 distanceCutoffChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#distanceModel-prop">QSpatialSound::<wbr/>distanceModelChanged()</a></code></p>
     */
    @QtPropertyNotify(name="distanceModel")
    public final @NonNull Signal0 distanceModelChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#loops-prop">QSpatialSound::<wbr/>loopsChanged()</a></code></p>
     */
    @QtPropertyNotify(name="loops")
    public final @NonNull Signal0 loopsChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#manualAttenuation-prop">QSpatialSound::<wbr/>manualAttenuationChanged()</a></code></p>
     */
    @QtPropertyNotify(name="manualAttenuation")
    public final @NonNull Signal0 manualAttenuationChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#nearFieldGain-prop">QSpatialSound::<wbr/>nearFieldGainChanged()</a></code></p>
     */
    @QtPropertyNotify(name="nearFieldGain")
    public final @NonNull Signal0 nearFieldGainChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#occlusionIntensity-prop">QSpatialSound::<wbr/>occlusionIntensityChanged()</a></code></p>
     */
    @QtPropertyNotify(name="occlusionIntensity")
    public final @NonNull Signal0 occlusionIntensityChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#position-prop">QSpatialSound::<wbr/>positionChanged()</a></code></p>
     */
    @QtPropertyNotify(name="position")
    public final @NonNull Signal0 positionChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#rotation-prop">QSpatialSound::<wbr/>rotationChanged()</a></code></p>
     */
    @QtPropertyNotify(name="rotation")
    public final @NonNull Signal0 rotationChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#size-prop">QSpatialSound::<wbr/>sizeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="size")
    public final @NonNull Signal0 sizeChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#source-prop">QSpatialSound::<wbr/>sourceChanged()</a></code></p>
     */
    @QtPropertyNotify(name="source")
    public final @NonNull Signal0 sourceChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#volume-prop">QSpatialSound::<wbr/>volumeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="volume")
    public final @NonNull Signal0 volumeChanged = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#QSpatialSound">QSpatialSound::<wbr/>QSpatialSound(QAudioEngine*)</a></code></p>
     */
    public QSpatialSound(io.qt.spatialaudio.@Nullable QAudioEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, engine);
    }
    
    private native static void initialize_native(QSpatialSound instance, io.qt.spatialaudio.QAudioEngine engine);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#autoPlay-prop">QSpatialSound::<wbr/>autoPlay()const</a></code></p>
     */
    @QtPropertyReader(name="autoPlay")
    @QtUninvokable
    public final boolean autoPlay(){
        return autoPlay_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoPlay_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#directivity-prop">QSpatialSound::<wbr/>directivity()const</a></code></p>
     */
    @QtPropertyReader(name="directivity")
    @QtUninvokable
    public final float directivity(){
        return directivity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float directivity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#directivityOrder-prop">QSpatialSound::<wbr/>directivityOrder()const</a></code></p>
     */
    @QtPropertyReader(name="directivityOrder")
    @QtUninvokable
    public final float directivityOrder(){
        return directivityOrder_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float directivityOrder_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#distanceCutoff-prop">QSpatialSound::<wbr/>distanceCutoff()const</a></code></p>
     */
    @QtPropertyReader(name="distanceCutoff")
    @QtUninvokable
    public final float distanceCutoff(){
        return distanceCutoff_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float distanceCutoff_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#distanceModel-prop">QSpatialSound::<wbr/>distanceModel()const</a></code></p>
     */
    @QtPropertyReader(name="distanceModel")
    @QtUninvokable
    public final io.qt.spatialaudio.QSpatialSound.@NonNull DistanceModel distanceModel(){
        return io.qt.spatialaudio.QSpatialSound.DistanceModel.resolve(distanceModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int distanceModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#engine">QSpatialSound::<wbr/>engine()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.spatialaudio.@Nullable QAudioEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.spatialaudio.QAudioEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#loops-prop">QSpatialSound::<wbr/>loops()const</a></code></p>
     */
    @QtPropertyReader(name="loops")
    @QtUninvokable
    public final int loops(){
        return loops_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int loops_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#manualAttenuation-prop">QSpatialSound::<wbr/>manualAttenuation()const</a></code></p>
     */
    @QtPropertyReader(name="manualAttenuation")
    @QtUninvokable
    public final float manualAttenuation(){
        return manualAttenuation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float manualAttenuation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#nearFieldGain-prop">QSpatialSound::<wbr/>nearFieldGain()const</a></code></p>
     */
    @QtPropertyReader(name="nearFieldGain")
    @QtUninvokable
    public final float nearFieldGain(){
        return nearFieldGain_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float nearFieldGain_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#occlusionIntensity-prop">QSpatialSound::<wbr/>occlusionIntensity()const</a></code></p>
     */
    @QtPropertyReader(name="occlusionIntensity")
    @QtUninvokable
    public final float occlusionIntensity(){
        return occlusionIntensity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float occlusionIntensity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#pause">QSpatialSound::<wbr/>pause()</a></code></p>
     */
    public final void pause(){
        pause_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void pause_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#play">QSpatialSound::<wbr/>play()</a></code></p>
     */
    public final void play(){
        play_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void play_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#position-prop">QSpatialSound::<wbr/>position()const</a></code></p>
     */
    @QtPropertyReader(name="position")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#rotation-prop">QSpatialSound::<wbr/>rotation()const</a></code></p>
     */
    @QtPropertyReader(name="rotation")
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#autoPlay-prop">QSpatialSound::<wbr/>setAutoPlay(bool)</a></code></p>
     */
    @QtPropertyWriter(name="autoPlay")
    @QtUninvokable
    public final void setAutoPlay(boolean autoPlay){
        setAutoPlay_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), autoPlay);
    }
    
    @QtUninvokable
    private native void setAutoPlay_native_bool(long __this__nativeId, boolean autoPlay);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#directivity-prop">QSpatialSound::<wbr/>setDirectivity(float)</a></code></p>
     */
    @QtPropertyWriter(name="directivity")
    @QtUninvokable
    public final void setDirectivity(float alpha){
        setDirectivity_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), alpha);
    }
    
    @QtUninvokable
    private native void setDirectivity_native_float(long __this__nativeId, float alpha);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#directivityOrder-prop">QSpatialSound::<wbr/>setDirectivityOrder(float)</a></code></p>
     */
    @QtPropertyWriter(name="directivityOrder")
    @QtUninvokable
    public final void setDirectivityOrder(float alpha){
        setDirectivityOrder_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), alpha);
    }
    
    @QtUninvokable
    private native void setDirectivityOrder_native_float(long __this__nativeId, float alpha);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#distanceCutoff-prop">QSpatialSound::<wbr/>setDistanceCutoff(float)</a></code></p>
     */
    @QtPropertyWriter(name="distanceCutoff")
    @QtUninvokable
    public final void setDistanceCutoff(float cutoff){
        setDistanceCutoff_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), cutoff);
    }
    
    @QtUninvokable
    private native void setDistanceCutoff_native_float(long __this__nativeId, float cutoff);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#distanceModel-prop">QSpatialSound::<wbr/>setDistanceModel(QSpatialSound::DistanceModel)</a></code></p>
     */
    @QtPropertyWriter(name="distanceModel")
    @QtUninvokable
    public final void setDistanceModel(io.qt.spatialaudio.QSpatialSound.@NonNull DistanceModel model){
        setDistanceModel_native_QSpatialSound_DistanceModel(QtJambi_LibraryUtilities.internal.nativeId(this), model.value());
    }
    
    @QtUninvokable
    private native void setDistanceModel_native_QSpatialSound_DistanceModel(long __this__nativeId, int model);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#loops-prop">QSpatialSound::<wbr/>setLoops(int)</a></code></p>
     */
    @QtPropertyWriter(name="loops")
    @QtUninvokable
    public final void setLoops(int loops){
        setLoops_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), loops);
    }
    
    @QtUninvokable
    private native void setLoops_native_int(long __this__nativeId, int loops);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#manualAttenuation-prop">QSpatialSound::<wbr/>setManualAttenuation(float)</a></code></p>
     */
    @QtPropertyWriter(name="manualAttenuation")
    @QtUninvokable
    public final void setManualAttenuation(float attenuation){
        setManualAttenuation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), attenuation);
    }
    
    @QtUninvokable
    private native void setManualAttenuation_native_float(long __this__nativeId, float attenuation);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#nearFieldGain-prop">QSpatialSound::<wbr/>setNearFieldGain(float)</a></code></p>
     */
    @QtPropertyWriter(name="nearFieldGain")
    @QtUninvokable
    public final void setNearFieldGain(float gain){
        setNearFieldGain_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), gain);
    }
    
    @QtUninvokable
    private native void setNearFieldGain_native_float(long __this__nativeId, float gain);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#occlusionIntensity-prop">QSpatialSound::<wbr/>setOcclusionIntensity(float)</a></code></p>
     */
    @QtPropertyWriter(name="occlusionIntensity")
    @QtUninvokable
    public final void setOcclusionIntensity(float occlusion){
        setOcclusionIntensity_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), occlusion);
    }
    
    @QtUninvokable
    private native void setOcclusionIntensity_native_float(long __this__nativeId, float occlusion);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#position-prop">QSpatialSound::<wbr/>setPosition(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="position")
    @QtUninvokable
    public final void setPosition(io.qt.gui.@NonNull QVector3D pos){
        setPosition_native_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pos));
    }
    
    @QtUninvokable
    private native void setPosition_native_QVector3D(long __this__nativeId, long pos);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#rotation-prop">QSpatialSound::<wbr/>setRotation(QQuaternion)</a></code></p>
     */
    @QtPropertyWriter(name="rotation")
    @QtUninvokable
    public final void setRotation(io.qt.gui.@NonNull QQuaternion q){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(q));
    }
    
    @QtUninvokable
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long q);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#size-prop">QSpatialSound::<wbr/>setSize(float)</a></code></p>
     */
    @QtPropertyWriter(name="size")
    @QtUninvokable
    public final void setSize(float size){
        setSize_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @QtUninvokable
    private native void setSize_native_float(long __this__nativeId, float size);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#source-prop">QSpatialSound::<wbr/>setSource(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="source")
    @QtUninvokable
    public final void setSource(io.qt.core.@NonNull QUrl url){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setSource_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#volume-prop">QSpatialSound::<wbr/>setVolume(float)</a></code></p>
     */
    @QtPropertyWriter(name="volume")
    @QtUninvokable
    public final void setVolume(float volume){
        setVolume_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), volume);
    }
    
    @QtUninvokable
    private native void setVolume_native_float(long __this__nativeId, float volume);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#size-prop">QSpatialSound::<wbr/>size()const</a></code></p>
     */
    @QtPropertyReader(name="size")
    @QtUninvokable
    public final float size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#source-prop">QSpatialSound::<wbr/>source()const</a></code></p>
     */
    @QtPropertyReader(name="source")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#stop">QSpatialSound::<wbr/>stop()</a></code></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qspatialsound.html#volume-prop">QSpatialSound::<wbr/>volume()const</a></code></p>
     */
    @QtPropertyReader(name="volume")
    @QtUninvokable
    public final float volume(){
        return volume_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float volume_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSpatialSound(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #autoPlay()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoPlay() {
        return autoPlay();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #directivity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDirectivity() {
        return directivity();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #directivityOrder()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDirectivityOrder() {
        return directivityOrder();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #distanceCutoff()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDistanceCutoff() {
        return distanceCutoff();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #distanceModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.spatialaudio.QSpatialSound.@NonNull DistanceModel getDistanceModel() {
        return distanceModel();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #loops()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getLoops() {
        return loops();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #manualAttenuation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getManualAttenuation() {
        return manualAttenuation();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #nearFieldGain()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getNearFieldGain() {
        return nearFieldGain();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #occlusionIntensity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getOcclusionIntensity() {
        return occlusionIntensity();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #position()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getPosition() {
        return position();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #rotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion getRotation() {
        return rotation();
    }
    
    /**
     * <p>Overloaded function for {@link #setSource(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setSource(java.lang.@NonNull String url) {
        setSource(new io.qt.core.QUrl(url));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #size()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getSize() {
        return size();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #source()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getSource() {
        return source();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #volume()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getVolume() {
        return volume();
    }
}
