package io.qt.spatialaudio;

import io.qt.*;


/**
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaudioroom.html">QAudioRoom</a></code></p>
 */
public class QAudioRoom extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAudioRoom.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::Material</a></code></p>
     */
    @QtUnlistedEnum
    public enum Material implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>Transparent</a></code></p>
         */
        Transparent(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>AcousticCeilingTiles</a></code></p>
         */
        AcousticCeilingTiles(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>BrickBare</a></code></p>
         */
        BrickBare(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>BrickPainted</a></code></p>
         */
        BrickPainted(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>ConcreteBlockCoarse</a></code></p>
         */
        ConcreteBlockCoarse(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>ConcreteBlockPainted</a></code></p>
         */
        ConcreteBlockPainted(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>CurtainHeavy</a></code></p>
         */
        CurtainHeavy(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>FiberGlassInsulation</a></code></p>
         */
        FiberGlassInsulation(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>GlassThin</a></code></p>
         */
        GlassThin(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>GlassThick</a></code></p>
         */
        GlassThick(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>Grass</a></code></p>
         */
        Grass(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>LinoleumOnConcrete</a></code></p>
         */
        LinoleumOnConcrete(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>Marble</a></code></p>
         */
        Marble(12),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>Metal</a></code></p>
         */
        Metal(13),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>ParquetOnConcrete</a></code></p>
         */
        ParquetOnConcrete(14),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>PlasterRough</a></code></p>
         */
        PlasterRough(15),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>PlasterSmooth</a></code></p>
         */
        PlasterSmooth(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>PlywoodPanel</a></code></p>
         */
        PlywoodPanel(17),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>PolishedConcreteOrTile</a></code></p>
         */
        PolishedConcreteOrTile(18),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>Sheetrock</a></code></p>
         */
        Sheetrock(19),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>WaterOrIceSurface</a></code></p>
         */
        WaterOrIceSurface(20),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>WoodCeiling</a></code></p>
         */
        WoodCeiling(21),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>WoodPanel</a></code></p>
         */
        WoodPanel(22),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::<wbr>UniformMaterial</a></code></p>
         */
        UniformMaterial(23);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Material(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Material resolve(int value) {
            switch (value) {
            case 0: return Transparent;
            case 1: return AcousticCeilingTiles;
            case 2: return BrickBare;
            case 3: return BrickPainted;
            case 4: return ConcreteBlockCoarse;
            case 5: return ConcreteBlockPainted;
            case 6: return CurtainHeavy;
            case 7: return FiberGlassInsulation;
            case 8: return GlassThin;
            case 9: return GlassThick;
            case 10: return Grass;
            case 11: return LinoleumOnConcrete;
            case 12: return Marble;
            case 13: return Metal;
            case 14: return ParquetOnConcrete;
            case 15: return PlasterRough;
            case 16: return PlasterSmooth;
            case 17: return PlywoodPanel;
            case 18: return PolishedConcreteOrTile;
            case 19: return Sheetrock;
            case 20: return WaterOrIceSurface;
            case 21: return WoodCeiling;
            case 22: return WoodPanel;
            case 23: return UniformMaterial;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qaudioroom.html#Wall-enum">QAudioRoom::Wall</a></code></p>
     */
    @QtUnlistedEnum
    public enum Wall implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Wall-enum">QAudioRoom::<wbr>LeftWall</a></code></p>
         */
        LeftWall(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Wall-enum">QAudioRoom::<wbr>RightWall</a></code></p>
         */
        RightWall(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Wall-enum">QAudioRoom::<wbr>Floor</a></code></p>
         */
        Floor(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Wall-enum">QAudioRoom::<wbr>Ceiling</a></code></p>
         */
        Ceiling(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Wall-enum">QAudioRoom::<wbr>FrontWall</a></code></p>
         */
        FrontWall(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioroom.html#Wall-enum">QAudioRoom::<wbr>BackWall</a></code></p>
         */
        BackWall(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Wall(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Wall resolve(int value) {
            switch (value) {
            case 0: return LeftWall;
            case 1: return RightWall;
            case 2: return Floor;
            case 3: return Ceiling;
            case 4: return FrontWall;
            case 5: return BackWall;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#dimensions-prop">QAudioRoom::<wbr>dimensionsChanged()</a></code></p>
     */
    @QtPropertyNotify(name="dimensions")
    public final @NonNull Signal0 dimensionsChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#position-prop">QAudioRoom::<wbr>positionChanged()</a></code></p>
     */
    @QtPropertyNotify(name="position")
    public final @NonNull Signal0 positionChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#reflectionGain-prop">QAudioRoom::<wbr>reflectionGainChanged()</a></code></p>
     */
    @QtPropertyNotify(name="reflectionGain")
    public final @NonNull Signal0 reflectionGainChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#reverbBrightness-prop">QAudioRoom::<wbr>reverbBrightnessChanged()</a></code></p>
     */
    @QtPropertyNotify(name="reverbBrightness")
    public final @NonNull Signal0 reverbBrightnessChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#reverbGain-prop">QAudioRoom::<wbr>reverbGainChanged()</a></code></p>
     */
    @QtPropertyNotify(name="reverbGain")
    public final @NonNull Signal0 reverbGainChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#reverbTime-prop">QAudioRoom::<wbr>reverbTimeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="reverbTime")
    public final @NonNull Signal0 reverbTimeChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#rotation-prop">QAudioRoom::<wbr>rotationChanged()</a></code></p>
     */
    @QtPropertyNotify(name="rotation")
    public final @NonNull Signal0 rotationChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#wallsChanged">QAudioRoom::<wbr>wallsChanged()</a></code></p>
     */
    public final @NonNull Signal0 wallsChanged = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#QAudioRoom">QAudioRoom::<wbr>QAudioRoom(QAudioEngine*)</a></code></p>
     */
    public QAudioRoom(io.qt.spatialaudio.@Nullable QAudioEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, engine);
    }
    
    private native static void initialize_native(QAudioRoom instance, io.qt.spatialaudio.QAudioEngine engine);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #dimensions()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getDimensions() {
        return dimensions();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#dimensions-prop">QAudioRoom::<wbr>dimensions()const</a></code></p>
     */
    @QtPropertyReader(name="dimensions")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D dimensions(){
        return dimensions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D dimensions_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #position()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getPosition() {
        return position();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#position-prop">QAudioRoom::<wbr>position()const</a></code></p>
     */
    @QtPropertyReader(name="position")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #reflectionGain()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getReflectionGain() {
        return reflectionGain();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#reflectionGain-prop">QAudioRoom::<wbr>reflectionGain()const</a></code></p>
     */
    @QtPropertyReader(name="reflectionGain")
    @QtUninvokable
    public final float reflectionGain(){
        return reflectionGain_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float reflectionGain_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #reverbBrightness()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getReverbBrightness() {
        return reverbBrightness();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#reverbBrightness-prop">QAudioRoom::<wbr>reverbBrightness()const</a></code></p>
     */
    @QtPropertyReader(name="reverbBrightness")
    @QtUninvokable
    public final float reverbBrightness(){
        return reverbBrightness_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float reverbBrightness_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #reverbGain()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getReverbGain() {
        return reverbGain();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#reverbGain-prop">QAudioRoom::<wbr>reverbGain()const</a></code></p>
     */
    @QtPropertyReader(name="reverbGain")
    @QtUninvokable
    public final float reverbGain(){
        return reverbGain_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float reverbGain_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #reverbTime()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getReverbTime() {
        return reverbTime();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#reverbTime-prop">QAudioRoom::<wbr>reverbTime()const</a></code></p>
     */
    @QtPropertyReader(name="reverbTime")
    @QtUninvokable
    public final float reverbTime(){
        return reverbTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float reverbTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion getRotation() {
        return rotation();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#rotation-prop">QAudioRoom::<wbr>rotation()const</a></code></p>
     */
    @QtPropertyReader(name="rotation")
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#dimensions-prop">QAudioRoom::<wbr>setDimensions(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="dimensions")
    @QtUninvokable
    public final void setDimensions(io.qt.gui.@NonNull QVector3D dim){
        setDimensions_native_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dim));
    }
    
    @QtUninvokable
    private native void setDimensions_native_QVector3D(long __this__nativeId, long dim);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#position-prop">QAudioRoom::<wbr>setPosition(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="position")
    @QtUninvokable
    public final void setPosition(io.qt.gui.@NonNull QVector3D pos){
        setPosition_native_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pos));
    }
    
    @QtUninvokable
    private native void setPosition_native_QVector3D(long __this__nativeId, long pos);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#reflectionGain-prop">QAudioRoom::<wbr>setReflectionGain(float)</a></code></p>
     */
    @QtPropertyWriter(name="reflectionGain")
    @QtUninvokable
    public final void setReflectionGain(float factor){
        setReflectionGain_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    @QtUninvokable
    private native void setReflectionGain_native_float(long __this__nativeId, float factor);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#reverbBrightness-prop">QAudioRoom::<wbr>setReverbBrightness(float)</a></code></p>
     */
    @QtPropertyWriter(name="reverbBrightness")
    @QtUninvokable
    public final void setReverbBrightness(float factor){
        setReverbBrightness_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    @QtUninvokable
    private native void setReverbBrightness_native_float(long __this__nativeId, float factor);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#reverbGain-prop">QAudioRoom::<wbr>setReverbGain(float)</a></code></p>
     */
    @QtPropertyWriter(name="reverbGain")
    @QtUninvokable
    public final void setReverbGain(float factor){
        setReverbGain_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    @QtUninvokable
    private native void setReverbGain_native_float(long __this__nativeId, float factor);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#reverbTime-prop">QAudioRoom::<wbr>setReverbTime(float)</a></code></p>
     */
    @QtPropertyWriter(name="reverbTime")
    @QtUninvokable
    public final void setReverbTime(float factor){
        setReverbTime_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    @QtUninvokable
    private native void setReverbTime_native_float(long __this__nativeId, float factor);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#rotation-prop">QAudioRoom::<wbr>setRotation(QQuaternion)</a></code></p>
     */
    @QtPropertyWriter(name="rotation")
    @QtUninvokable
    public final void setRotation(io.qt.gui.@NonNull QQuaternion q){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(q));
    }
    
    @QtUninvokable
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long q);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#setWallMaterial">QAudioRoom::<wbr>setWallMaterial(QAudioRoom::Wall,<wbr>QAudioRoom::Material)</a></code></p>
     */
    @QtUninvokable
    public final void setWallMaterial(io.qt.spatialaudio.QAudioRoom.@NonNull Wall wall, io.qt.spatialaudio.QAudioRoom.@NonNull Material material){
        setWallMaterial_native_QAudioRoom_Wall_QAudioRoom_Material(QtJambi_LibraryUtilities.internal.nativeId(this), wall.value(), material.value());
    }
    
    @QtUninvokable
    private native void setWallMaterial_native_QAudioRoom_Wall_QAudioRoom_Material(long __this__nativeId, int wall, int material);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioroom.html#wallMaterial">QAudioRoom::<wbr>wallMaterial(QAudioRoom::Wall)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.spatialaudio.QAudioRoom.@NonNull Material wallMaterial(io.qt.spatialaudio.QAudioRoom.@NonNull Wall wall){
        return io.qt.spatialaudio.QAudioRoom.Material.resolve(wallMaterial_native_QAudioRoom_Wall_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), wall.value()));
    }
    
    @QtUninvokable
    private native int wallMaterial_native_QAudioRoom_Wall_constfct(long __this__nativeId, int wall);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAudioRoom(QPrivateConstructor p) { super(p); } 
    
}
