package io.qt.spatialaudio;

import io.qt.*;


/**
 * <p>A sound object in 3D space</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qspatialsound.html">QSpatialSound</a></p>
 */
public class QSpatialSound extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSpatialSound.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qspatialsound.html#DistanceModel-enum">QSpatialSound::DistanceModel</a></p>
     */
    public enum DistanceModel implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qspatialsound.html#DistanceModel-enum">QSpatialSound::DistanceModel::Logarithmic</a></p>
         */
        Logarithmic(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qspatialsound.html#DistanceModel-enum">QSpatialSound::DistanceModel::Linear</a></p>
         */
        Linear(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qspatialsound.html#DistanceModel-enum">QSpatialSound::DistanceModel::ManualAttenuation</a></p>
         */
        ManualAttenuation(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DistanceModel(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DistanceModel resolve(int value) {
            switch (value) {
            case 0: return Logarithmic;
            case 1: return Linear;
            case 2: return ManualAttenuation;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qspatialsound.html#Loops-enum">QSpatialSound::Loops</a></p>
     */
    public enum Loops implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qspatialsound.html#Loops-enum">QSpatialSound::Infinite</a></p>
         */
        Infinite(-1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qspatialsound.html#Loops-enum">QSpatialSound::Once</a></p>
         */
        Once(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Loops(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Loops resolve(int value) {
            switch (value) {
            case -1: return Infinite;
            case 1: return Once;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#autoPlay-prop">QSpatialSound::autoPlayChanged()</a></p>
     */
    @QtPropertyNotify(name="autoPlay")
    public final @NonNull Signal0 autoPlayChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#directivity-prop">QSpatialSound::directivityChanged()</a></p>
     */
    @QtPropertyNotify(name="directivity")
    public final @NonNull Signal0 directivityChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#directivityOrder-prop">QSpatialSound::directivityOrderChanged()</a></p>
     */
    @QtPropertyNotify(name="directivityOrder")
    public final @NonNull Signal0 directivityOrderChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#distanceCutoff-prop">QSpatialSound::distanceCutoffChanged()</a></p>
     */
    @QtPropertyNotify(name="distanceCutoff")
    public final @NonNull Signal0 distanceCutoffChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#distanceModel-prop">QSpatialSound::distanceModelChanged()</a></p>
     */
    @QtPropertyNotify(name="distanceModel")
    public final @NonNull Signal0 distanceModelChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#loops-prop">QSpatialSound::loopsChanged()</a></p>
     */
    @QtPropertyNotify(name="loops")
    public final @NonNull Signal0 loopsChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#manualAttenuation-prop">QSpatialSound::manualAttenuationChanged()</a></p>
     */
    @QtPropertyNotify(name="manualAttenuation")
    public final @NonNull Signal0 manualAttenuationChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#nearFieldGain-prop">QSpatialSound::nearFieldGainChanged()</a></p>
     */
    @QtPropertyNotify(name="nearFieldGain")
    public final @NonNull Signal0 nearFieldGainChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#occlusionIntensity-prop">QSpatialSound::occlusionIntensityChanged()</a></p>
     */
    @QtPropertyNotify(name="occlusionIntensity")
    public final @NonNull Signal0 occlusionIntensityChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#position-prop">QSpatialSound::positionChanged()</a></p>
     */
    @QtPropertyNotify(name="position")
    public final @NonNull Signal0 positionChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#rotation-prop">QSpatialSound::rotationChanged()</a></p>
     */
    @QtPropertyNotify(name="rotation")
    public final @NonNull Signal0 rotationChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#size-prop">QSpatialSound::sizeChanged()</a></p>
     */
    @QtPropertyNotify(name="size")
    public final @NonNull Signal0 sizeChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#source-prop">QSpatialSound::sourceChanged()</a></p>
     */
    @QtPropertyNotify(name="source")
    public final @NonNull Signal0 sourceChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#volume-prop">QSpatialSound::volumeChanged()</a></p>
     */
    @QtPropertyNotify(name="volume")
    public final @NonNull Signal0 volumeChanged = new Signal0();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#QSpatialSound">QSpatialSound::QSpatialSound(QAudioEngine*)</a></p>
     */
    public QSpatialSound(io.qt.spatialaudio.@Nullable QAudioEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, engine);
    }
    
    private native static void initialize_native(QSpatialSound instance, io.qt.spatialaudio.QAudioEngine engine);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #autoPlay()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoPlay() {
        return autoPlay();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#autoPlay-prop">QSpatialSound::autoPlay()const</a></p>
     */
    @QtPropertyReader(name="autoPlay")
    @QtUninvokable
    public final boolean autoPlay(){
        return autoPlay_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoPlay_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #directivity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDirectivity() {
        return directivity();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#directivity-prop">QSpatialSound::directivity()const</a></p>
     */
    @QtPropertyReader(name="directivity")
    @QtUninvokable
    public final float directivity(){
        return directivity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float directivity_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #directivityOrder()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDirectivityOrder() {
        return directivityOrder();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#directivityOrder-prop">QSpatialSound::directivityOrder()const</a></p>
     */
    @QtPropertyReader(name="directivityOrder")
    @QtUninvokable
    public final float directivityOrder(){
        return directivityOrder_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float directivityOrder_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #distanceCutoff()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDistanceCutoff() {
        return distanceCutoff();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#distanceCutoff-prop">QSpatialSound::distanceCutoff()const</a></p>
     */
    @QtPropertyReader(name="distanceCutoff")
    @QtUninvokable
    public final float distanceCutoff(){
        return distanceCutoff_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float distanceCutoff_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #distanceModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.spatialaudio.QSpatialSound.@NonNull DistanceModel getDistanceModel() {
        return distanceModel();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#distanceModel-prop">QSpatialSound::distanceModel()const</a></p>
     */
    @QtPropertyReader(name="distanceModel")
    @QtUninvokable
    public final io.qt.spatialaudio.QSpatialSound.@NonNull DistanceModel distanceModel(){
        return io.qt.spatialaudio.QSpatialSound.DistanceModel.resolve(distanceModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int distanceModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#engine">QSpatialSound::engine()const</a></p>
     */
    @QtUninvokable
    public final io.qt.spatialaudio.@Nullable QAudioEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.spatialaudio.QAudioEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #loops()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getLoops() {
        return loops();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#loops-prop">QSpatialSound::loops()const</a></p>
     */
    @QtPropertyReader(name="loops")
    @QtUninvokable
    public final int loops(){
        return loops_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int loops_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #manualAttenuation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getManualAttenuation() {
        return manualAttenuation();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#manualAttenuation-prop">QSpatialSound::manualAttenuation()const</a></p>
     */
    @QtPropertyReader(name="manualAttenuation")
    @QtUninvokable
    public final float manualAttenuation(){
        return manualAttenuation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float manualAttenuation_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #nearFieldGain()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getNearFieldGain() {
        return nearFieldGain();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#nearFieldGain-prop">QSpatialSound::nearFieldGain()const</a></p>
     */
    @QtPropertyReader(name="nearFieldGain")
    @QtUninvokable
    public final float nearFieldGain(){
        return nearFieldGain_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float nearFieldGain_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #occlusionIntensity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getOcclusionIntensity() {
        return occlusionIntensity();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#occlusionIntensity-prop">QSpatialSound::occlusionIntensity()const</a></p>
     */
    @QtPropertyReader(name="occlusionIntensity")
    @QtUninvokable
    public final float occlusionIntensity(){
        return occlusionIntensity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float occlusionIntensity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#pause">QSpatialSound::pause()</a></p>
     */
    public final void pause(){
        pause_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void pause_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#play">QSpatialSound::play()</a></p>
     */
    public final void play(){
        play_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void play_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #position()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getPosition() {
        return position();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#position-prop">QSpatialSound::position()const</a></p>
     */
    @QtPropertyReader(name="position")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion getRotation() {
        return rotation();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#rotation-prop">QSpatialSound::rotation()const</a></p>
     */
    @QtPropertyReader(name="rotation")
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#autoPlay-prop">QSpatialSound::setAutoPlay(bool)</a></p>
     */
    @QtPropertyWriter(name="autoPlay")
    @QtUninvokable
    public final void setAutoPlay(boolean autoPlay){
        setAutoPlay_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), autoPlay);
    }
    
    @QtUninvokable
    private native void setAutoPlay_native_bool(long __this__nativeId, boolean autoPlay);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#directivity-prop">QSpatialSound::setDirectivity(float)</a></p>
     */
    @QtPropertyWriter(name="directivity")
    @QtUninvokable
    public final void setDirectivity(float alpha){
        setDirectivity_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), alpha);
    }
    
    @QtUninvokable
    private native void setDirectivity_native_float(long __this__nativeId, float alpha);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#directivityOrder-prop">QSpatialSound::setDirectivityOrder(float)</a></p>
     */
    @QtPropertyWriter(name="directivityOrder")
    @QtUninvokable
    public final void setDirectivityOrder(float alpha){
        setDirectivityOrder_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), alpha);
    }
    
    @QtUninvokable
    private native void setDirectivityOrder_native_float(long __this__nativeId, float alpha);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#distanceCutoff-prop">QSpatialSound::setDistanceCutoff(float)</a></p>
     */
    @QtPropertyWriter(name="distanceCutoff")
    @QtUninvokable
    public final void setDistanceCutoff(float cutoff){
        setDistanceCutoff_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), cutoff);
    }
    
    @QtUninvokable
    private native void setDistanceCutoff_native_float(long __this__nativeId, float cutoff);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#distanceModel-prop">QSpatialSound::setDistanceModel(QSpatialSound::DistanceModel)</a></p>
     */
    @QtPropertyWriter(name="distanceModel")
    @QtUninvokable
    public final void setDistanceModel(io.qt.spatialaudio.QSpatialSound.@NonNull DistanceModel model){
        setDistanceModel_native_QSpatialSound_DistanceModel(QtJambi_LibraryUtilities.internal.nativeId(this), model.value());
    }
    
    @QtUninvokable
    private native void setDistanceModel_native_QSpatialSound_DistanceModel(long __this__nativeId, int model);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#loops-prop">QSpatialSound::setLoops(int)</a></p>
     */
    @QtPropertyWriter(name="loops")
    @QtUninvokable
    public final void setLoops(int loops){
        setLoops_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), loops);
    }
    
    @QtUninvokable
    private native void setLoops_native_int(long __this__nativeId, int loops);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#manualAttenuation-prop">QSpatialSound::setManualAttenuation(float)</a></p>
     */
    @QtPropertyWriter(name="manualAttenuation")
    @QtUninvokable
    public final void setManualAttenuation(float attenuation){
        setManualAttenuation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), attenuation);
    }
    
    @QtUninvokable
    private native void setManualAttenuation_native_float(long __this__nativeId, float attenuation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#nearFieldGain-prop">QSpatialSound::setNearFieldGain(float)</a></p>
     */
    @QtPropertyWriter(name="nearFieldGain")
    @QtUninvokable
    public final void setNearFieldGain(float gain){
        setNearFieldGain_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), gain);
    }
    
    @QtUninvokable
    private native void setNearFieldGain_native_float(long __this__nativeId, float gain);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#occlusionIntensity-prop">QSpatialSound::setOcclusionIntensity(float)</a></p>
     */
    @QtPropertyWriter(name="occlusionIntensity")
    @QtUninvokable
    public final void setOcclusionIntensity(float occlusion){
        setOcclusionIntensity_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), occlusion);
    }
    
    @QtUninvokable
    private native void setOcclusionIntensity_native_float(long __this__nativeId, float occlusion);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#position-prop">QSpatialSound::setPosition(QVector3D)</a></p>
     */
    @QtPropertyWriter(name="position")
    @QtUninvokable
    public final void setPosition(io.qt.gui.@NonNull QVector3D pos){
        setPosition_native_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pos));
    }
    
    @QtUninvokable
    private native void setPosition_native_QVector3D(long __this__nativeId, long pos);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#rotation-prop">QSpatialSound::setRotation(QQuaternion)</a></p>
     */
    @QtPropertyWriter(name="rotation")
    @QtUninvokable
    public final void setRotation(io.qt.gui.@NonNull QQuaternion q){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(q));
    }
    
    @QtUninvokable
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long q);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#size-prop">QSpatialSound::setSize(float)</a></p>
     */
    @QtPropertyWriter(name="size")
    @QtUninvokable
    public final void setSize(float size){
        setSize_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @QtUninvokable
    private native void setSize_native_float(long __this__nativeId, float size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#source-prop">QSpatialSound::setSource(QUrl)</a></p>
     */
    @QtPropertyWriter(name="source")
    @QtUninvokable
    public final void setSource(io.qt.core.@NonNull QUrl url){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setSource_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#volume-prop">QSpatialSound::setVolume(float)</a></p>
     */
    @QtPropertyWriter(name="volume")
    @QtUninvokable
    public final void setVolume(float volume){
        setVolume_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), volume);
    }
    
    @QtUninvokable
    private native void setVolume_native_float(long __this__nativeId, float volume);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #size()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getSize() {
        return size();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#size-prop">QSpatialSound::size()const</a></p>
     */
    @QtPropertyReader(name="size")
    @QtUninvokable
    public final float size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float size_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #source()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getSource() {
        return source();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#source-prop">QSpatialSound::source()const</a></p>
     */
    @QtPropertyReader(name="source")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#stop">QSpatialSound::stop()</a></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #volume()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getVolume() {
        return volume();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qspatialsound.html#volume-prop">QSpatialSound::volume()const</a></p>
     */
    @QtPropertyReader(name="volume")
    @QtUninvokable
    public final float volume(){
        return volume_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float volume_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSpatialSound(QPrivateConstructor p) { super(p); } 
    
}
