package io.qt.spatialaudio;

import io.qt.*;


/**
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qaudioroom.html">QAudioRoom</a></p>
 */
public class QAudioRoom extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAudioRoom.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::Material</a></p>
     */
    @QtUnlistedEnum
    public enum Material implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::Transparent</a></p>
         */
        Transparent(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::AcousticCeilingTiles</a></p>
         */
        AcousticCeilingTiles(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::BrickBare</a></p>
         */
        BrickBare(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::BrickPainted</a></p>
         */
        BrickPainted(3),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::ConcreteBlockCoarse</a></p>
         */
        ConcreteBlockCoarse(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::ConcreteBlockPainted</a></p>
         */
        ConcreteBlockPainted(5),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::CurtainHeavy</a></p>
         */
        CurtainHeavy(6),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::FiberGlassInsulation</a></p>
         */
        FiberGlassInsulation(7),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::GlassThin</a></p>
         */
        GlassThin(8),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::GlassThick</a></p>
         */
        GlassThick(9),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::Grass</a></p>
         */
        Grass(10),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::LinoleumOnConcrete</a></p>
         */
        LinoleumOnConcrete(11),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::Marble</a></p>
         */
        Marble(12),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::Metal</a></p>
         */
        Metal(13),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::ParquetOnConcrete</a></p>
         */
        ParquetOnConcrete(14),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::PlasterRough</a></p>
         */
        PlasterRough(15),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::PlasterSmooth</a></p>
         */
        PlasterSmooth(16),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::PlywoodPanel</a></p>
         */
        PlywoodPanel(17),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::PolishedConcreteOrTile</a></p>
         */
        PolishedConcreteOrTile(18),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::Sheetrock</a></p>
         */
        Sheetrock(19),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::WaterOrIceSurface</a></p>
         */
        WaterOrIceSurface(20),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::WoodCeiling</a></p>
         */
        WoodCeiling(21),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::WoodPanel</a></p>
         */
        WoodPanel(22),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Material-enum">QAudioRoom::UniformMaterial</a></p>
         */
        UniformMaterial(23);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Material(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Material resolve(int value) {
            switch (value) {
            case 0: return Transparent;
            case 1: return AcousticCeilingTiles;
            case 2: return BrickBare;
            case 3: return BrickPainted;
            case 4: return ConcreteBlockCoarse;
            case 5: return ConcreteBlockPainted;
            case 6: return CurtainHeavy;
            case 7: return FiberGlassInsulation;
            case 8: return GlassThin;
            case 9: return GlassThick;
            case 10: return Grass;
            case 11: return LinoleumOnConcrete;
            case 12: return Marble;
            case 13: return Metal;
            case 14: return ParquetOnConcrete;
            case 15: return PlasterRough;
            case 16: return PlasterSmooth;
            case 17: return PlywoodPanel;
            case 18: return PolishedConcreteOrTile;
            case 19: return Sheetrock;
            case 20: return WaterOrIceSurface;
            case 21: return WoodCeiling;
            case 22: return WoodPanel;
            case 23: return UniformMaterial;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qaudioroom.html#Wall-enum">QAudioRoom::Wall</a></p>
     */
    @QtUnlistedEnum
    public enum Wall implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Wall-enum">QAudioRoom::LeftWall</a></p>
         */
        LeftWall(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Wall-enum">QAudioRoom::RightWall</a></p>
         */
        RightWall(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Wall-enum">QAudioRoom::Floor</a></p>
         */
        Floor(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Wall-enum">QAudioRoom::Ceiling</a></p>
         */
        Ceiling(3),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Wall-enum">QAudioRoom::FrontWall</a></p>
         */
        FrontWall(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qaudioroom.html#Wall-enum">QAudioRoom::BackWall</a></p>
         */
        BackWall(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Wall(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Wall resolve(int value) {
            switch (value) {
            case 0: return LeftWall;
            case 1: return RightWall;
            case 2: return Floor;
            case 3: return Ceiling;
            case 4: return FrontWall;
            case 5: return BackWall;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#dimensions-prop">QAudioRoom::dimensionsChanged()</a></p>
     */
    @QtPropertyNotify(name="dimensions")
    public final @NonNull Signal0 dimensionsChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#position-prop">QAudioRoom::positionChanged()</a></p>
     */
    @QtPropertyNotify(name="position")
    public final @NonNull Signal0 positionChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#reflectionGain-prop">QAudioRoom::reflectionGainChanged()</a></p>
     */
    @QtPropertyNotify(name="reflectionGain")
    public final @NonNull Signal0 reflectionGainChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#reverbBrightness-prop">QAudioRoom::reverbBrightnessChanged()</a></p>
     */
    @QtPropertyNotify(name="reverbBrightness")
    public final @NonNull Signal0 reverbBrightnessChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#reverbGain-prop">QAudioRoom::reverbGainChanged()</a></p>
     */
    @QtPropertyNotify(name="reverbGain")
    public final @NonNull Signal0 reverbGainChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#reverbTime-prop">QAudioRoom::reverbTimeChanged()</a></p>
     */
    @QtPropertyNotify(name="reverbTime")
    public final @NonNull Signal0 reverbTimeChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#rotation-prop">QAudioRoom::rotationChanged()</a></p>
     */
    @QtPropertyNotify(name="rotation")
    public final @NonNull Signal0 rotationChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#wallsChanged">QAudioRoom::wallsChanged()</a></p>
     */
    public final @NonNull Signal0 wallsChanged = new Signal0();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#QAudioRoom">QAudioRoom::QAudioRoom(QAudioEngine*)</a></p>
     */
    public QAudioRoom(io.qt.spatialaudio.@Nullable QAudioEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, engine);
    }
    
    private native static void initialize_native(QAudioRoom instance, io.qt.spatialaudio.QAudioEngine engine);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #dimensions()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getDimensions() {
        return dimensions();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#dimensions-prop">QAudioRoom::dimensions()const</a></p>
     */
    @QtPropertyReader(name="dimensions")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D dimensions(){
        return dimensions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D dimensions_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #position()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getPosition() {
        return position();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#position-prop">QAudioRoom::position()const</a></p>
     */
    @QtPropertyReader(name="position")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #reflectionGain()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getReflectionGain() {
        return reflectionGain();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#reflectionGain-prop">QAudioRoom::reflectionGain()const</a></p>
     */
    @QtPropertyReader(name="reflectionGain")
    @QtUninvokable
    public final float reflectionGain(){
        return reflectionGain_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float reflectionGain_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #reverbBrightness()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getReverbBrightness() {
        return reverbBrightness();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#reverbBrightness-prop">QAudioRoom::reverbBrightness()const</a></p>
     */
    @QtPropertyReader(name="reverbBrightness")
    @QtUninvokable
    public final float reverbBrightness(){
        return reverbBrightness_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float reverbBrightness_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #reverbGain()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getReverbGain() {
        return reverbGain();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#reverbGain-prop">QAudioRoom::reverbGain()const</a></p>
     */
    @QtPropertyReader(name="reverbGain")
    @QtUninvokable
    public final float reverbGain(){
        return reverbGain_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float reverbGain_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #reverbTime()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getReverbTime() {
        return reverbTime();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#reverbTime-prop">QAudioRoom::reverbTime()const</a></p>
     */
    @QtPropertyReader(name="reverbTime")
    @QtUninvokable
    public final float reverbTime(){
        return reverbTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float reverbTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion getRotation() {
        return rotation();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#rotation-prop">QAudioRoom::rotation()const</a></p>
     */
    @QtPropertyReader(name="rotation")
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#dimensions-prop">QAudioRoom::setDimensions(QVector3D)</a></p>
     */
    @QtPropertyWriter(name="dimensions")
    @QtUninvokable
    public final void setDimensions(io.qt.gui.@NonNull QVector3D dim){
        setDimensions_native_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dim));
    }
    
    @QtUninvokable
    private native void setDimensions_native_QVector3D(long __this__nativeId, long dim);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#position-prop">QAudioRoom::setPosition(QVector3D)</a></p>
     */
    @QtPropertyWriter(name="position")
    @QtUninvokable
    public final void setPosition(io.qt.gui.@NonNull QVector3D pos){
        setPosition_native_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pos));
    }
    
    @QtUninvokable
    private native void setPosition_native_QVector3D(long __this__nativeId, long pos);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#reflectionGain-prop">QAudioRoom::setReflectionGain(float)</a></p>
     */
    @QtPropertyWriter(name="reflectionGain")
    @QtUninvokable
    public final void setReflectionGain(float factor){
        setReflectionGain_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    @QtUninvokable
    private native void setReflectionGain_native_float(long __this__nativeId, float factor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#reverbBrightness-prop">QAudioRoom::setReverbBrightness(float)</a></p>
     */
    @QtPropertyWriter(name="reverbBrightness")
    @QtUninvokable
    public final void setReverbBrightness(float factor){
        setReverbBrightness_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    @QtUninvokable
    private native void setReverbBrightness_native_float(long __this__nativeId, float factor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#reverbGain-prop">QAudioRoom::setReverbGain(float)</a></p>
     */
    @QtPropertyWriter(name="reverbGain")
    @QtUninvokable
    public final void setReverbGain(float factor){
        setReverbGain_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    @QtUninvokable
    private native void setReverbGain_native_float(long __this__nativeId, float factor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#reverbTime-prop">QAudioRoom::setReverbTime(float)</a></p>
     */
    @QtPropertyWriter(name="reverbTime")
    @QtUninvokable
    public final void setReverbTime(float factor){
        setReverbTime_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    @QtUninvokable
    private native void setReverbTime_native_float(long __this__nativeId, float factor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#rotation-prop">QAudioRoom::setRotation(QQuaternion)</a></p>
     */
    @QtPropertyWriter(name="rotation")
    @QtUninvokable
    public final void setRotation(io.qt.gui.@NonNull QQuaternion q){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(q));
    }
    
    @QtUninvokable
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long q);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#setWallMaterial">QAudioRoom::setWallMaterial(QAudioRoom::Wall,QAudioRoom::Material)</a></p>
     */
    @QtUninvokable
    public final void setWallMaterial(io.qt.spatialaudio.QAudioRoom.@NonNull Wall wall, io.qt.spatialaudio.QAudioRoom.@NonNull Material material){
        setWallMaterial_native_QAudioRoom_Wall_QAudioRoom_Material(QtJambi_LibraryUtilities.internal.nativeId(this), wall.value(), material.value());
    }
    
    @QtUninvokable
    private native void setWallMaterial_native_QAudioRoom_Wall_QAudioRoom_Material(long __this__nativeId, int wall, int material);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudioroom.html#wallMaterial">QAudioRoom::wallMaterial(QAudioRoom::Wall)const</a></p>
     */
    @QtUninvokable
    public final io.qt.spatialaudio.QAudioRoom.@NonNull Material wallMaterial(io.qt.spatialaudio.QAudioRoom.@NonNull Wall wall){
        return io.qt.spatialaudio.QAudioRoom.Material.resolve(wallMaterial_native_QAudioRoom_Wall_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), wall.value()));
    }
    
    @QtUninvokable
    private native int wallMaterial_native_QAudioRoom_Wall_constfct(long __this__nativeId, int wall);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAudioRoom(QPrivateConstructor p) { super(p); } 
    
}
