package io.qt.spatialaudio;

import io.qt.*;


/**
 * <p>Defines the position and orientation of the person listening to a sound field defined by QAudioEngine</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qaudiolistener.html">QAudioListener</a></p>
 */
public class QAudioListener extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudiolistener.html#QAudioListener">QAudioListener::QAudioListener(QAudioEngine*)</a></p>
     */
    public QAudioListener(io.qt.spatialaudio.@Nullable QAudioEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, engine);
    }
    
    private native static void initialize_native(QAudioListener instance, io.qt.spatialaudio.QAudioEngine engine);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudiolistener.html#engine">QAudioListener::engine()const</a></p>
     */
    @QtUninvokable
    public final io.qt.spatialaudio.@Nullable QAudioEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.spatialaudio.QAudioEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudiolistener.html#position">QAudioListener::position()const</a></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudiolistener.html#rotation">QAudioListener::rotation()const</a></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudiolistener.html#setPosition">QAudioListener::setPosition(QVector3D)</a></p>
     */
    @QtUninvokable
    public final void setPosition(io.qt.gui.@NonNull QVector3D pos){
        setPosition_native_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pos));
    }
    
    @QtUninvokable
    private native void setPosition_native_QVector3D(long __this__nativeId, long pos);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaudiolistener.html#setRotation">QAudioListener::setRotation(QQuaternion)</a></p>
     */
    @QtUninvokable
    public final void setRotation(io.qt.gui.@NonNull QQuaternion q){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(q));
    }
    
    @QtUninvokable
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long q);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAudioListener(QPrivateConstructor p) { super(p); } 
    
}
