#include <QtCore/QtGlobal>
#include <QtSerialBus/qcansignaldescription.h>
#include <QtCore/QHash>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qdebug.h>
#include <QtCore/qsysinfo.h>
#include <QtSerialBus/qcancommondefinitions.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QCanSignalDescription(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QCanSignalDescription")
    QCanSignalDescription *_ptr = reinterpret_cast<QCanSignalDescription *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QCanSignalDescription()
void __qt_construct_QCanSignalDescription(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCanSignalDescription()")
    Q_UNUSED(__java_arguments)
    QCanSignalDescription *__qt_this = new(__qtjambi_ptr) QCanSignalDescription();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QCanSignalDescription::QCanSignalDescription()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_initialize_1native__Lio_qt_serialbus_QCanSignalDescription_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCanSignalDescription::QCanSignalDescription()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCanSignalDescription, sizeof(QCanSignalDescription), typeid(QCanSignalDescription), false, &deleter_QCanSignalDescription, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QCanSignalDescription(QCanSignalDescription)
void __qt_construct_QCanSignalDescription_cref_QCanSignalDescription(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCanSignalDescription(QCanSignalDescription)")
    jobject other0 = __java_arguments[0].l;
    const QCanSignalDescription& __qt_other0 = qtjambi_cast<const QCanSignalDescription& >(__jni_env, other0);
    QCanSignalDescription *__qt_this = new(__qtjambi_ptr) QCanSignalDescription(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QCanSignalDescription::QCanSignalDescription(QCanSignalDescription)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_initialize_1native__Lio_qt_serialbus_QCanSignalDescription_2Lio_qt_serialbus_QCanSignalDescription_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCanSignalDescription::QCanSignalDescription(QCanSignalDescription)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCanSignalDescription_cref_QCanSignalDescription, sizeof(QCanSignalDescription), typeid(QCanSignalDescription), false, &deleter_QCanSignalDescription, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QCanSignalDescription
void __qt_destruct_QCanSignalDescription(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QCanSignalDescription")
    reinterpret_cast<QCanSignalDescription*>(ptr)->~QCanSignalDescription();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QCanSignalDescription::addMultiplexSignal(QString,QCanSignalDescription::MultiplexValues)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_addMultiplexSignal_1native_1cref_1QString_1cref_1QList__JLjava_lang_String_2Ljava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0,
 jobject ranges1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::addMultiplexSignal(QString,QCanSignalDescription::MultiplexValues)", __qt_this)
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        const QList<QCanSignalDescription::MultiplexValueRange>&  __qt_ranges1 = qtjambi_cast<const QList<QCanSignalDescription::MultiplexValueRange>& >(__jni_env, __qtjambi_scope, ranges1);
        __qt_this->addMultiplexSignal(__qt_name0, __qt_ranges1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::addMultiplexSignal(QString,QVariant)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_addMultiplexSignal_1native_1cref_1QString_1cref_1QVariant__JLjava_lang_String_2Ljava_lang_Object_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0,
 jobject value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::addMultiplexSignal(QString,QVariant)", __qt_this)
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        QVariant  __qt_value1 = qtjambi_cast<QVariant >(__jni_env, value1);
        __qt_this->addMultiplexSignal(__qt_name0, __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::bitLength()const
extern "C" Q_DECL_EXPORT jshort JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_bitLength_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jshort __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::bitLength()const", __qt_this)
        quint16 __qt_return_value = __qt_this->bitLength();
        __java_return_value = jshort(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::clearMultiplexSignals()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_clearMultiplexSignals_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::clearMultiplexSignals()", __qt_this)
        __qt_this->clearMultiplexSignals();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::comment()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_comment_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::comment()const", __qt_this)
        QString __qt_return_value = __qt_this->comment();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::dataEndian()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_dataEndian_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::dataEndian()const", __qt_this)
        QSysInfo::Endian __qt_return_value = __qt_this->dataEndian();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::dataFormat()const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_dataFormat_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::dataFormat()const", __qt_this)
        QtCanBus::DataFormat __qt_return_value = __qt_this->dataFormat();
        __java_return_value = jbyte(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::dataSource()const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_dataSource_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::dataSource()const", __qt_this)
        QtCanBus::DataSource __qt_return_value = __qt_this->dataSource();
        __java_return_value = jbyte(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::factor()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_factor_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::factor()const", __qt_this)
        __java_return_value = __qt_this->factor();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::maximum()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_maximum_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::maximum()const", __qt_this)
        __java_return_value = __qt_this->maximum();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::minimum()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_minimum_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::minimum()const", __qt_this)
        __java_return_value = __qt_this->minimum();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::multiplexSignals()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_multiplexSignals_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::multiplexSignals()const", __qt_this)
        QHash<QString, QList<QCanSignalDescription::MultiplexValueRange> > __qt_return_value = __qt_this->multiplexSignals();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::multiplexState()const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_multiplexState_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::multiplexState()const", __qt_this)
        QtCanBus::MultiplexState __qt_return_value = __qt_this->multiplexState();
        __java_return_value = jbyte(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::name()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_name_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::name()const", __qt_this)
        QString __qt_return_value = __qt_this->name();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::offset()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_offset_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::offset()const", __qt_this)
        __java_return_value = __qt_this->offset();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::operator=(QCanSignalDescription)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_assign_1native_1cref_1QCanSignalDescription__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::operator=(QCanSignalDescription)", __qt_this)
        const QCanSignalDescription& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QCanSignalDescription>(__jni_env, other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::physicalUnit()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_physicalUnit_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::physicalUnit()const", __qt_this)
        QString __qt_return_value = __qt_this->physicalUnit();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::receiver()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_receiver_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::receiver()const", __qt_this)
        QString __qt_return_value = __qt_this->receiver();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::scaling()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_scaling_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::scaling()const", __qt_this)
        __java_return_value = __qt_this->scaling();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::setBitLength(quint16)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setBitLength_1native_1quint16__JS)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort length0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setBitLength(quint16)", __qt_this)
        __qt_this->setBitLength(static_cast<quint16>(length0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::setComment(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setComment_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring text0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setComment(QString)", __qt_this)
        QString  __qt_text0 = qtjambi_cast<QString>(__jni_env, text0);
        __qt_this->setComment(__qt_text0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::setDataEndian(QSysInfo::Endian)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setDataEndian_1native_1QSysInfo_1Endian__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint endian0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setDataEndian(QSysInfo::Endian)", __qt_this)
        QSysInfo::Endian __qt_endian0 = qtjambi_cast<QSysInfo::Endian>(__jni_env, endian0);
        __qt_this->setDataEndian(QSysInfo::Endian(__qt_endian0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::setDataFormat(QtCanBus::DataFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setDataFormat_1native_1QtCanBus_1DataFormat__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte format0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setDataFormat(QtCanBus::DataFormat)", __qt_this)
        QtCanBus::DataFormat __qt_format0 = qtjambi_cast<QtCanBus::DataFormat>(__jni_env, format0);
        __qt_this->setDataFormat(QtCanBus::DataFormat(__qt_format0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::setDataSource(QtCanBus::DataSource)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setDataSource_1native_1QtCanBus_1DataSource__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte source0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setDataSource(QtCanBus::DataSource)", __qt_this)
        QtCanBus::DataSource __qt_source0 = qtjambi_cast<QtCanBus::DataSource>(__jni_env, source0);
        __qt_this->setDataSource(QtCanBus::DataSource(__qt_source0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::setFactor(double)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setFactor_1native_1double__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble factor0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setFactor(double)", __qt_this)
        __qt_this->setFactor(static_cast<double>(factor0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::setMultiplexSignals(QCanSignalDescription::MultiplexSignalValues)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setMultiplexSignals_1native_1cref_1QHash__JLjava_util_Map_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject multiplexorSignals0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setMultiplexSignals(QCanSignalDescription::MultiplexSignalValues)", __qt_this)
        const QHash<QString, QList<QCanSignalDescription::MultiplexValueRange> >&  __qt_multiplexorSignals0 = qtjambi_cast<const QHash<QString, QList<QCanSignalDescription::MultiplexValueRange> >& >(__jni_env, __qtjambi_scope, multiplexorSignals0);
        __qt_this->setMultiplexSignals(__qt_multiplexorSignals0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::setMultiplexState(QtCanBus::MultiplexState)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setMultiplexState_1native_1QtCanBus_1MultiplexState__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte state0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setMultiplexState(QtCanBus::MultiplexState)", __qt_this)
        QtCanBus::MultiplexState __qt_state0 = qtjambi_cast<QtCanBus::MultiplexState>(__jni_env, state0);
        __qt_this->setMultiplexState(QtCanBus::MultiplexState(__qt_state0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::setName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setName(QString)", __qt_this)
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        __qt_this->setName(__qt_name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::setOffset(double)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setOffset_1native_1double__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble offset0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setOffset(double)", __qt_this)
        __qt_this->setOffset(static_cast<double>(offset0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::setPhysicalUnit(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setPhysicalUnit_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring unit0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setPhysicalUnit(QString)", __qt_this)
        QString  __qt_unit0 = qtjambi_cast<QString>(__jni_env, unit0);
        __qt_this->setPhysicalUnit(__qt_unit0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::setRange(double,double)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setRange_1native_1double_1double__JDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble minimum0,
 jdouble maximum1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setRange(double,double)", __qt_this)
        __qt_this->setRange(static_cast<double>(minimum0), static_cast<double>(maximum1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::setReceiver(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setReceiver_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring receiver0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setReceiver(QString)", __qt_this)
        QString  __qt_receiver0 = qtjambi_cast<QString>(__jni_env, receiver0);
        __qt_this->setReceiver(__qt_receiver0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::setScaling(double)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setScaling_1native_1double__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble scaling0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setScaling(double)", __qt_this)
        __qt_this->setScaling(static_cast<double>(scaling0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::setStartBit(quint16)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_setStartBit_1native_1quint16__JS)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort bit0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::setStartBit(quint16)", __qt_this)
        __qt_this->setStartBit(static_cast<quint16>(bit0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanSignalDescription::startBit()const
extern "C" Q_DECL_EXPORT jshort JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_startBit_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jshort __java_return_value{0};
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::startBit()const", __qt_this)
        quint16 __qt_return_value = __qt_this->startBit();
        __java_return_value = jshort(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanSignalDescription::swap(QCanSignalDescription&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_swap_1native_1ref_1QCanSignalDescription__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanSignalDescription::swap(QCanSignalDescription&)", __qt_this)
        QCanSignalDescription& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QCanSignalDescription>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanSignalDescription_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QCanSignalDescription *__qt_this = QtJambiAPI::objectFromNativeId<QCanSignalDescription>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QCanSignalDescription(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QCanSignalDescription>("QCanSignalDescription", "io/qt/serialbus/QCanSignalDescription");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QCanSignalDescription, {
        ConstructorInfo(&__qt_construct_QCanSignalDescription, nullptr)
       ,ConstructorInfo(&__qt_construct_QCanSignalDescription_cref_QCanSignalDescription, "Lio/qt/serialbus/QCanSignalDescription;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QCanSignalDescription);
    registerMetaType<QCanSignalDescription>("QCanSignalDescription");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
