#include <QtCore/QtGlobal>
#include <QtSerialBus/qcanframeprocessor.h>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtSerialBus/qcanbusframe.h>
#include <QtSerialBus/qcancommondefinitions.h>
#include <QtSerialBus/qcanmessagedescription.h>
#include <QtSerialBus/qcanuniqueiddescription.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QCanFrameProcessor(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QCanFrameProcessor")
    QCanFrameProcessor *_ptr = reinterpret_cast<QCanFrameProcessor *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QCanFrameProcessor()
void __qt_construct_QCanFrameProcessor_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCanFrameProcessor()")
    Q_UNUSED(__java_arguments)
    QCanFrameProcessor *__qt_this = new(__qtjambi_ptr) QCanFrameProcessor();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// destruct QCanFrameProcessor
void __qt_destruct_QCanFrameProcessor(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QCanFrameProcessor")
    reinterpret_cast<QCanFrameProcessor*>(ptr)->~QCanFrameProcessor();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QCanFrameProcessor::QCanFrameProcessor()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanFrameProcessor_initialize_1native__Lio_qt_serialbus_QCanFrameProcessor_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCanFrameProcessor::QCanFrameProcessor()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCanFrameProcessor_0, sizeof(QCanFrameProcessor), typeid(QCanFrameProcessor), false, &deleter_QCanFrameProcessor, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanFrameProcessor::addMessageDescriptions(QList<QCanMessageDescription>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanFrameProcessor_addMessageDescriptions_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject descriptions0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanFrameProcessor *__qt_this = QtJambiAPI::objectFromNativeId<QCanFrameProcessor>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanFrameProcessor::addMessageDescriptions(QList<QCanMessageDescription>)", __qt_this)
        const QList<QCanMessageDescription>&  __qt_descriptions0 = qtjambi_cast<const QList<QCanMessageDescription>& >(__jni_env, __qtjambi_scope, descriptions0);
        __qt_this->addMessageDescriptions(__qt_descriptions0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanFrameProcessor::clearMessageDescriptions()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanFrameProcessor_clearMessageDescriptions_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanFrameProcessor *__qt_this = QtJambiAPI::objectFromNativeId<QCanFrameProcessor>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanFrameProcessor::clearMessageDescriptions()", __qt_this)
        __qt_this->clearMessageDescriptions();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanFrameProcessor::error()const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanFrameProcessor_error_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QCanFrameProcessor *__qt_this = QtJambiAPI::objectFromNativeId<QCanFrameProcessor>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanFrameProcessor::error()const", __qt_this)
        QCanFrameProcessor::Error __qt_return_value = __qt_this->error();
        __java_return_value = jbyte(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanFrameProcessor::errorString()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanFrameProcessor_errorString_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QCanFrameProcessor *__qt_this = QtJambiAPI::objectFromNativeId<QCanFrameProcessor>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanFrameProcessor::errorString()const", __qt_this)
        QString __qt_return_value = __qt_this->errorString();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanFrameProcessor::messageDescriptions()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanFrameProcessor_messageDescriptions_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QCanFrameProcessor *__qt_this = QtJambiAPI::objectFromNativeId<QCanFrameProcessor>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanFrameProcessor::messageDescriptions()const", __qt_this)
        QList<QCanMessageDescription> __qt_return_value = __qt_this->messageDescriptions();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanFrameProcessor::parseFrame(QCanBusFrame)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanFrameProcessor_parseFrame_1native_1cref_1QCanBusFrame__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID frame0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QCanFrameProcessor *__qt_this = QtJambiAPI::objectFromNativeId<QCanFrameProcessor>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanFrameProcessor::parseFrame(QCanBusFrame)", __qt_this)
        const QCanBusFrame& __qt_frame0 = QtJambiAPI::valueReferenceFromNativeId<QCanBusFrame>(frame0);
        QCanFrameProcessor::ParseResult __qt_return_value = __qt_this->parseFrame(__qt_frame0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanFrameProcessor::prepareFrame(QtCanBus::UniqueId,QVariantMap)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanFrameProcessor_prepareFrame_1native_1QtCanBus_1UniqueId_1cref_1QMap__JILjava_util_Map_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint uniqueId0,
 jobject signalValues1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QCanFrameProcessor *__qt_this = QtJambiAPI::objectFromNativeId<QCanFrameProcessor>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanFrameProcessor::prepareFrame(QtCanBus::UniqueId,QVariantMap)", __qt_this)
        QtCanBus::UniqueId __qt_uniqueId0 = qtjambi_cast<QtCanBus::UniqueId>(__jni_env, uniqueId0);
        const QMap<QString, QVariant>&  __qt_signalValues1 = qtjambi_cast<const QMap<QString, QVariant>& >(__jni_env, __qtjambi_scope, signalValues1);
        QCanBusFrame __qt_return_value = __qt_this->prepareFrame(QtCanBus::UniqueId(__qt_uniqueId0), __qt_signalValues1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanFrameProcessor::setMessageDescriptions(QList<QCanMessageDescription>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanFrameProcessor_setMessageDescriptions_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject descriptions0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanFrameProcessor *__qt_this = QtJambiAPI::objectFromNativeId<QCanFrameProcessor>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanFrameProcessor::setMessageDescriptions(QList<QCanMessageDescription>)", __qt_this)
        const QList<QCanMessageDescription>&  __qt_descriptions0 = qtjambi_cast<const QList<QCanMessageDescription>& >(__jni_env, __qtjambi_scope, descriptions0);
        __qt_this->setMessageDescriptions(__qt_descriptions0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanFrameProcessor::setUniqueIdDescription(QCanUniqueIdDescription)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanFrameProcessor_setUniqueIdDescription_1native_1cref_1QCanUniqueIdDescription__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID description0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCanFrameProcessor *__qt_this = QtJambiAPI::objectFromNativeId<QCanFrameProcessor>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanFrameProcessor::setUniqueIdDescription(QCanUniqueIdDescription)", __qt_this)
        const QCanUniqueIdDescription& __qt_description0 = QtJambiAPI::objectReferenceFromNativeId<QCanUniqueIdDescription>(__jni_env, description0);
        __qt_this->setUniqueIdDescription(__qt_description0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCanFrameProcessor::uniqueIdDescription()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanFrameProcessor_uniqueIdDescription_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QCanFrameProcessor *__qt_this = QtJambiAPI::objectFromNativeId<QCanFrameProcessor>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanFrameProcessor::uniqueIdDescription()const", __qt_this)
        QCanUniqueIdDescription __qt_return_value = __qt_this->uniqueIdDescription();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCanFrameProcessor::warnings()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_serialbus_QCanFrameProcessor_warnings_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QCanFrameProcessor *__qt_this = QtJambiAPI::objectFromNativeId<QCanFrameProcessor>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCanFrameProcessor::warnings()const", __qt_this)
        QStringList __qt_return_value = __qt_this->warnings();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QCanFrameProcessor(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QCanFrameProcessor>("QCanFrameProcessor", "io/qt/serialbus/QCanFrameProcessor");
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QCanFrameProcessor, {
        ConstructorInfo(&__qt_construct_QCanFrameProcessor_0, nullptr)
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QCanFrameProcessor);
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QCanFrameProcessor::Error>("QCanFrameProcessor::Error", "io/qt/serialbus/QCanFrameProcessor$Error");
// END: enums and flags
}
