package io.qt.sensors;

import io.qt.*;
import static io.qt.QtUtilities.*;

/**
 * @hidden
 */
final class QtJambi_LibraryUtilities {

    final static int qtMajorVersion = 6;

    final static int qtMinorVersion = 7;

    final static int qtJambiPatch = 1;

    final static InternalAccess internal;

    static{
        try {
            initializePackage("io.qt.core");
            loadQtLibrary("Sensors", LibraryRequirementMode.Mandatory);
            loadQtJambiLibrary("Sensors");
        } catch(Error t) {
            throw t;
        } catch(Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
        internal = internalAccess();
    }
    private static native InternalAccess internalAccess();

    static void initialize() { };

    private QtJambi_LibraryUtilities() throws InstantiationError { throw new InstantiationError("Cannot instantiate QtJambi_LibraryUtilities."); }
}

