package io.qt.sensors;

import io.qt.*;


/**
 * <p>Convenience wrapper around QSensorFilter</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qtiltfilter.html">QTiltFilter</a></code></p>
 */
public interface QTiltFilter extends QtObjectInterface, io.qt.sensors.QSensorFilter
{
    /**
     * @hidden
     * <p>Implementor class for interface {@link io.qt.sensors.QTiltFilter}</p>
     */
    public static abstract class Impl extends QtObject
        implements io.qt.sensors.QTiltFilter,
                io.qt.sensors.QSensorFilter
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @QtPropertyMember(enabled=false)
        private Object __rcSensor = null;
        
        @NativeAccess
        private static final class ConcreteWrapper extends QTiltFilter.Impl {
            
            @NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @QtUninvokable
            public boolean filter(io.qt.sensors.@Nullable QTiltReading reading){
                return filter_native_QTiltReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(reading));
            }
            private native static boolean filter_native_QTiltReading_ptr(long __this__nativeId, long reading);
            
        }
        
        
        /**
         * Function has no implementation because its native counterpart is private.
         */
        @Deprecated
        @QtUninvokable
        @Override
        public final boolean filter(io.qt.sensors.@Nullable QSensorReading reading) throws QNoImplementationException {
            throw new QNoImplementationException();
        }
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qtiltfilter.html#filter">QTiltFilter::<wbr/>filter(QTiltReading*)</a></code></p>
         */
        @QtUninvokable
        public abstract boolean filter(io.qt.sensors.@Nullable QTiltReading reading);
        
        private native static boolean filter_native_QTiltReading_ptr(long __this__nativeId, long reading);
        
        /**
         * <p>See <code>QSensorFilter::<wbr/>setSensor(QSensor*)</code></p>
         */
        @QtUninvokable
        protected void setSensor(io.qt.sensors.@Nullable QSensor sensor){
            setSensor_native_QSensor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sensor));
            __rcSensor = sensor;
        }
        
        private native static void setSensor_native_QSensor_ptr(long __this__nativeId, long sensor);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qtiltfilter.html#filter">QTiltFilter::<wbr/>filter(QTiltReading*)</a></code></p>
     */
    @QtUninvokable
    public boolean filter(io.qt.sensors.@Nullable QTiltReading reading);
    
}
