package io.qt.sensors;

import io.qt.*;


/**
 * <p>Efficient callback facility for asynchronous notifications of sensor changes</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsensorfilter.html">QSensorFilter</a></code></p>
 * <p>Following functions are protected in the Qt interface, all implementations of this interface may implement these function:</p>
 * <br>
 * <code>
 * &commat;QtUninvokable<br>
 * protected void setSensor(io.qt.sensors.&commat;Nullable QSensor sensor){<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;QSensorFilter.MemberAccess.of(this).setSensor(sensor);<br>
 * }<br>
 * <br>
 * &commat;QtUninvokable<br>
 * protected final io.qt.sensors.&commat;Nullable QSensor sensor(){<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;return QSensorFilter.MemberAccess.of(this).sensor();<br>
 * }<br>
 * <br>
 * </code>
 */
public interface QSensorFilter extends QtObjectInterface
{
    /**
     * @hidden
     * <p>Implementor class for interface {@link io.qt.sensors.QSensorFilter}</p>
     */
    public static abstract class Impl extends QtObject
        implements io.qt.sensors.QSensorFilter
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @QtPropertyMember(enabled=false)
        private Object __rcSensor = null;
        
        @NativeAccess
        private static final class ConcreteWrapper extends QSensorFilter.Impl {
            
            @NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @QtUninvokable
            public boolean filter(io.qt.sensors.@Nullable QSensorReading reading){
                return filter_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(reading));
            }
            private native static boolean filter_native_QSensorReading_ptr(long __this__nativeId, long reading);
            
        }
        
        
        /**
         * <p>See <code>QSensorFilter::<wbr/>QSensorFilter()</code></p>
         */
        protected Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QSensorFilter instance);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qsensorfilter.html#filter">QSensorFilter::<wbr/>filter(QSensorReading*)</a></code></p>
         */
        @QtUninvokable
        public abstract boolean filter(io.qt.sensors.@Nullable QSensorReading reading);
        
        private native static boolean filter_native_QSensorReading_ptr(long __this__nativeId, long reading);
        
        /**
         * <p>See <code>QSensorFilter::<wbr/>setSensor(QSensor*)</code></p>
         */
        @QtUninvokable
        protected void setSensor(io.qt.sensors.@Nullable QSensor sensor){
            setSensor_native_QSensor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sensor));
            __rcSensor = sensor;
        }
        
        private native static void setSensor_native_QSensor_ptr(long __this__nativeId, long sensor);
        
        /**
         * <p>See <code>QSensorFilter::<wbr/>m_sensor</code></p>
         */
        @QtUninvokable
        protected final io.qt.sensors.@Nullable QSensor sensor(){
            return sensor_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native io.qt.sensors.QSensor sensor_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #sensor()} instead.</p>
         */
        @QtUninvokable
        protected final io.qt.sensors.@Nullable QSensor getSensor() {
            return sensor();
        }
    }

    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorfilter.html#filter">QSensorFilter::<wbr/>filter(QSensorReading*)</a></code></p>
     */
    @QtUninvokable
    public boolean filter(io.qt.sensors.@Nullable QSensorReading reading);
    
    
    /**
     * @hidden
     */
    public static class MemberAccess extends io.qt.MemberAccess<QSensorFilter> {
        private MemberAccess(QSensorFilter instance){
            super(instance);
        }
        
        @QtUninvokable
        public void setSensor(io.qt.sensors.@Nullable QSensor sensor){
            QSensorFilter instance = instance();
            QSensorFilter.Impl.setSensor_native_QSensor_ptr(QtJambi_LibraryUtilities.internal.nativeId(instance), QtJambi_LibraryUtilities.internal.checkedNativeId(sensor));
            QtJambi_LibraryUtilities.internal.setReferenceCount(instance, io.qt.sensors.QSensorFilter.class, "__rcSensor", false, false, sensor);
        }
        
        public static MemberAccess of(QSensorFilter instance){
            Class<?> callerClass = QtJambi_LibraryUtilities.internal.callerClassProvider().get();
            if(!QSensorFilter.class.isAssignableFrom(callerClass) || !callerClass.isInstance(instance))
                throw new RuntimeException("Access to restricted functions of class QSensorFilter is only granted from inside a user-implemented subclass.");
            return QtJambi_LibraryUtilities.internal.findMemberAccess(instance, QSensorFilter.class, MemberAccess.class);
        }
    }
}
