package io.qt.sensors;

import io.qt.*;


/**
 * <p>Instantiates instances of QSensorBackend</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsensorbackendfactory.html">QSensorBackendFactory</a></code></p>
 */
public interface QSensorBackendFactory extends QtObjectInterface
{
    /**
     * @hidden
     * <p>Implementor class for interface {@link io.qt.sensors.QSensorBackendFactory}</p>
     */
    public static abstract class Impl extends QtObject
        implements io.qt.sensors.QSensorBackendFactory
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @NativeAccess
        private static final class ConcreteWrapper extends QSensorBackendFactory.Impl {
            
            @NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @QtUninvokable
            public io.qt.sensors.@Nullable QSensorBackend createBackend(io.qt.sensors.@Nullable QSensor sensor){
                return createBackend_native_QSensor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sensor));
            }
            private native static io.qt.sensors.QSensorBackend createBackend_native_QSensor_ptr(long __this__nativeId, long sensor);
            
        }
        
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackendfactory.html#createBackend">QSensorBackendFactory::<wbr/>createBackend(QSensor*)</a></code></p>
         */
        @QtUninvokable
        public abstract io.qt.sensors.@Nullable QSensorBackend createBackend(io.qt.sensors.@Nullable QSensor sensor);
        
        private native static io.qt.sensors.QSensorBackend createBackend_native_QSensor_ptr(long __this__nativeId, long sensor);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackendfactory.html#createBackend">QSensorBackendFactory::<wbr/>createBackend(QSensor*)</a></code></p>
     */
    @QtUninvokable
    public io.qt.sensors.@Nullable QSensorBackend createBackend(io.qt.sensors.@Nullable QSensor sensor);
    
}
