package io.qt.sensors;

import io.qt.*;


/**
 * <p>Represents one reading from the orientation sensor</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qorientationreading.html">QOrientationReading</a></code></p>
 */
public class QOrientationReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOrientationReading.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qorientationreading.html#Orientation-enum">QOrientationReading::Orientation</a></code></p>
     */
    public enum Orientation implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qorientationreading.html#Orientation-enum">QOrientationReading::<wbr/>Undefined</a></code></p>
         */
        Undefined(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qorientationreading.html#Orientation-enum">QOrientationReading::<wbr/>TopUp</a></code></p>
         */
        TopUp(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qorientationreading.html#Orientation-enum">QOrientationReading::<wbr/>TopDown</a></code></p>
         */
        TopDown(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qorientationreading.html#Orientation-enum">QOrientationReading::<wbr/>LeftUp</a></code></p>
         */
        LeftUp(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qorientationreading.html#Orientation-enum">QOrientationReading::<wbr/>RightUp</a></code></p>
         */
        RightUp(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qorientationreading.html#Orientation-enum">QOrientationReading::<wbr/>FaceUp</a></code></p>
         */
        FaceUp(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qorientationreading.html#Orientation-enum">QOrientationReading::<wbr/>FaceDown</a></code></p>
         */
        FaceDown(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Orientation(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Orientation resolve(int value) {
            switch (value) {
            case 0: return Undefined;
            case 1: return TopUp;
            case 2: return TopDown;
            case 3: return LeftUp;
            case 4: return RightUp;
            case 5: return FaceUp;
            case 6: return FaceDown;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code>QOrientationReading::<wbr/>QOrientationReading(QObject*)</code></p>
     */
    public QOrientationReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QOrientationReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qorientationreading.html#orientation-prop">QOrientationReading::<wbr/>orientation()const</a></code></p>
     */
    @QtPropertyReader(name="orientation")
    @QtUninvokable
    public final io.qt.sensors.QOrientationReading.@NonNull Orientation orientation(){
        return io.qt.sensors.QOrientationReading.Orientation.resolve(orientation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int orientation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qorientationreading.html#setOrientation">QOrientationReading::<wbr/>setOrientation(QOrientationReading::Orientation)</a></code></p>
     */
    @QtUninvokable
    public final void setOrientation(io.qt.sensors.QOrientationReading.@NonNull Orientation orientation){
        setOrientation_native_QOrientationReading_Orientation(QtJambi_LibraryUtilities.internal.nativeId(this), orientation.value());
    }
    
    @QtUninvokable
    private native void setOrientation_native_QOrientationReading_Orientation(long __this__nativeId, int orientation);
    
    /**
     * <p>See <code>QSensorReading::<wbr/>copyValuesFrom(QSensorReading*)</code></p>
     */
    @QtUninvokable
    @Override
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOrientationReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QOrientationReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QOrientationReading instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QOrientationReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QOrientationReading() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #orientation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.sensors.QOrientationReading.@NonNull Orientation getOrientation() {
        return orientation();
    }
}
