package io.qt.sensors;

import io.qt.*;


/**
 * <p>Represents one reading from a compass</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qcompassreading.html">QCompassReading</a></code></p>
 */
public class QCompassReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCompassReading.class);
    
    
    /**
     * <p>See <code>QCompassReading::<wbr/>QCompassReading(QObject*)</code></p>
     */
    public QCompassReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QCompassReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcompassreading.html#azimuth-prop">QCompassReading::<wbr/>azimuth()const</a></code></p>
     */
    @QtPropertyReader(name="azimuth")
    @QtUninvokable
    public final double azimuth(){
        return azimuth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double azimuth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcompassreading.html#calibrationLevel-prop">QCompassReading::<wbr/>calibrationLevel()const</a></code></p>
     */
    @QtPropertyReader(name="calibrationLevel")
    @QtUninvokable
    public final double calibrationLevel(){
        return calibrationLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double calibrationLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcompassreading.html#setAzimuth">QCompassReading::<wbr/>setAzimuth(qreal)</a></code></p>
     */
    @QtUninvokable
    public final void setAzimuth(double azimuth){
        setAzimuth_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), azimuth);
    }
    
    @QtUninvokable
    private native void setAzimuth_native_qreal(long __this__nativeId, double azimuth);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcompassreading.html#setCalibrationLevel">QCompassReading::<wbr/>setCalibrationLevel(qreal)</a></code></p>
     */
    @QtUninvokable
    public final void setCalibrationLevel(double calibrationLevel){
        setCalibrationLevel_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), calibrationLevel);
    }
    
    @QtUninvokable
    private native void setCalibrationLevel_native_qreal(long __this__nativeId, double calibrationLevel);
    
    /**
     * <p>See <code>QSensorReading::<wbr/>copyValuesFrom(QSensorReading*)</code></p>
     */
    @QtUninvokable
    @Override
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QCompassReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QCompassReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QCompassReading instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QCompassReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCompassReading() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #azimuth()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getAzimuth() {
        return azimuth();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #calibrationLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getCalibrationLevel() {
        return calibrationLevel();
    }
}
