package io.qt.sensors;

import io.qt.*;


/**
 * <p>Convenience wrapper around QSensor</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaccelerometer.html">QAccelerometer</a></code></p>
 */
public class QAccelerometer extends io.qt.sensors.QSensor
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAccelerometer.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qaccelerometer.html#AccelerationMode-enum">QAccelerometer::AccelerationMode</a></code></p>
     */
    public enum AccelerationMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaccelerometer.html#AccelerationMode-enum">QAccelerometer::<wbr/>Combined</a></code></p>
         */
        Combined(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaccelerometer.html#AccelerationMode-enum">QAccelerometer::<wbr/>Gravity</a></code></p>
         */
        Gravity(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaccelerometer.html#AccelerationMode-enum">QAccelerometer::<wbr/>User</a></code></p>
         */
        User(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AccelerationMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull AccelerationMode resolve(int value) {
            switch (value) {
            case 0: return Combined;
            case 1: return Gravity;
            case 2: return User;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaccelerometer.html#accelerationModeChanged">QAccelerometer::<wbr/>accelerationModeChanged(QAccelerometer::AccelerationMode)</a></code></p>
     */
    @QtPropertyNotify(name="accelerationMode")
    public final @NonNull Signal1<io.qt.sensors.QAccelerometer.@NonNull AccelerationMode> accelerationModeChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaccelerometer.html#QAccelerometer">QAccelerometer::<wbr/>QAccelerometer(QObject*)</a></code></p>
     */
    public QAccelerometer(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAccelerometer instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaccelerometer.html#accelerationMode-prop">QAccelerometer::<wbr/>accelerationMode()const</a></code></p>
     */
    @QtPropertyReader(name="accelerationMode")
    @QtUninvokable
    public final io.qt.sensors.QAccelerometer.@NonNull AccelerationMode accelerationMode(){
        return io.qt.sensors.QAccelerometer.AccelerationMode.resolve(accelerationMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int accelerationMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#reading-prop">QSensor::<wbr/>reading()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sensors.@Nullable QAccelerometerReading reading(){
        return reading_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sensors.QAccelerometerReading reading_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaccelerometer.html#setAccelerationMode">QAccelerometer::<wbr/>setAccelerationMode(QAccelerometer::AccelerationMode)</a></code></p>
     */
    @QtPropertyWriter(name="accelerationMode")
    @QtUninvokable
    public final void setAccelerationMode(io.qt.sensors.QAccelerometer.@NonNull AccelerationMode accelerationMode){
        setAccelerationMode_native_QAccelerometer_AccelerationMode(QtJambi_LibraryUtilities.internal.nativeId(this), accelerationMode.value());
    }
    
    @QtUninvokable
    private native void setAccelerationMode_native_QAccelerometer_AccelerationMode(long __this__nativeId, int accelerationMode);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAccelerometer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAccelerometer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAccelerometer instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAccelerometer(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAccelerometer() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #accelerationMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.sensors.QAccelerometer.@NonNull AccelerationMode getAccelerationMode() {
        return accelerationMode();
    }
}
