package io.qt.sensors;

import io.qt.*;


/**
 * <p>Holds the readings from the sensor</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsensorreading.html">QSensorReading</a></code></p>
 */
public class QSensorReading extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSensorReading.class);
    
    
    /**
     * <p>See <code>QSensorReading::<wbr>QSensorReading(QObject*,<wbr>QSensorReadingPrivate*)</code></p>
     */
    protected QSensorReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSensorReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorreading.html#setTimestamp">QSensorReading::<wbr>setTimestamp(quint64)</a></code></p>
     */
    @QtUninvokable
    public final void setTimestamp(long timestamp){
        setTimestamp_native_quint64(QtJambi_LibraryUtilities.internal.nativeId(this), timestamp);
    }
    
    @QtUninvokable
    private native void setTimestamp_native_quint64(long __this__nativeId, long timestamp);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorreading.html#timestamp">QSensorReading::<wbr>timestamp()const</a></code></p>
     */
    @QtPropertyReader(name="timestamp")
    @QtUninvokable
    public final long timestamp(){
        return timestamp_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long timestamp_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorreading.html#value">QSensorReading::<wbr>value(int)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object value(int index){
        return value_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native java.lang.Object value_native_int_constfct(long __this__nativeId, int index);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorreading.html#valueCount">QSensorReading::<wbr>valueCount()const</a></code></p>
     */
    @QtUninvokable
    public final int valueCount(){
        return valueCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int valueCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QSensorReading::<wbr>copyValuesFrom(QSensorReading*)</code></p>
     */
    @QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSensorReading(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Kotlin property getter. In Java use {@link #timestamp()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final long getTimestamp() {
        return timestamp();
    }
}
