package io.qt.sensors;

import io.qt.*;


/**
 * <p>Holds readings from the pressure sensor</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qpressurereading.html">QPressureReading</a></code></p>
 */
public class QPressureReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPressureReading.class);
    
    
    /**
     * <p>See <code>QPressureReading::<wbr>QPressureReading(QObject*)</code></p>
     */
    public QPressureReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPressureReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpressurereading.html#pressure-prop">QPressureReading::<wbr>pressure()const</a></code></p>
     */
    @QtPropertyReader(name="pressure")
    @QtUninvokable
    public final double pressure(){
        return pressure_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double pressure_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpressurereading.html#setPressure">QPressureReading::<wbr>setPressure(qreal)</a></code></p>
     */
    @QtUninvokable
    public final void setPressure(double pressure){
        setPressure_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), pressure);
    }
    
    @QtUninvokable
    private native void setPressure_native_qreal(long __this__nativeId, double pressure);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpressurereading.html#setTemperature">QPressureReading::<wbr>setTemperature(qreal)</a></code></p>
     */
    @QtUninvokable
    public final void setTemperature(double temperature){
        setTemperature_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), temperature);
    }
    
    @QtUninvokable
    private native void setTemperature_native_qreal(long __this__nativeId, double temperature);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpressurereading.html#temperature-prop">QPressureReading::<wbr>temperature()const</a></code></p>
     */
    @QtPropertyReader(name="temperature")
    @QtUninvokable
    public final double temperature(){
        return temperature_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double temperature_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QSensorReading::<wbr>copyValuesFrom(QSensorReading*)</code></p>
     */
    @QtUninvokable
    @Override
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPressureReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QPressureReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPressureReading instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QPressureReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QPressureReading() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #pressure()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getPressure() {
        return pressure();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #temperature()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getTemperature() {
        return temperature();
    }
}
