package io.qt.sensors;

import io.qt.*;


/**
 * <p>Reports on linear acceleration along the X, Y and Z axes</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaccelerometerreading.html">QAccelerometerReading</a></code></p>
 */
public class QAccelerometerReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAccelerometerReading.class);
    
    
    /**
     * <p>See <code>QAccelerometerReading::<wbr>QAccelerometerReading(QObject*)</code></p>
     */
    public QAccelerometerReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAccelerometerReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaccelerometerreading.html#setX">QAccelerometerReading::<wbr>setX(qreal)</a></code></p>
     */
    @QtUninvokable
    public final void setX(double x){
        setX_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), x);
    }
    
    @QtUninvokable
    private native void setX_native_qreal(long __this__nativeId, double x);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaccelerometerreading.html#setY">QAccelerometerReading::<wbr>setY(qreal)</a></code></p>
     */
    @QtUninvokable
    public final void setY(double y){
        setY_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), y);
    }
    
    @QtUninvokable
    private native void setY_native_qreal(long __this__nativeId, double y);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaccelerometerreading.html#setZ">QAccelerometerReading::<wbr>setZ(qreal)</a></code></p>
     */
    @QtUninvokable
    public final void setZ(double z){
        setZ_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), z);
    }
    
    @QtUninvokable
    private native void setZ_native_qreal(long __this__nativeId, double z);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaccelerometerreading.html#x-prop">QAccelerometerReading::<wbr>x()const</a></code></p>
     */
    @QtPropertyReader(name="x")
    @QtUninvokable
    public final double x(){
        return x_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double x_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaccelerometerreading.html#y-prop">QAccelerometerReading::<wbr>y()const</a></code></p>
     */
    @QtPropertyReader(name="y")
    @QtUninvokable
    public final double y(){
        return y_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double y_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaccelerometerreading.html#z-prop">QAccelerometerReading::<wbr>z()const</a></code></p>
     */
    @QtPropertyReader(name="z")
    @QtUninvokable
    public final double z(){
        return z_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double z_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QSensorReading::<wbr>copyValuesFrom(QSensorReading*)</code></p>
     */
    @QtUninvokable
    @Override
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAccelerometerReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAccelerometerReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAccelerometerReading instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAccelerometerReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAccelerometerReading() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #x()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getX() {
        return x();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #y()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getY() {
        return y();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #z()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getZ() {
        return z();
    }
}
