package io.qt.sensors;

import io.qt.*;


/**
 * <p>The pure virtual interface to sensor plugins</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsensorplugininterface.html">QSensorPluginInterface</a></code></p>
 */
public interface QSensorPluginInterface extends QtObjectInterface
{
    /**
     * @hidden
     * <p>Implementor class for interface {@link io.qt.sensors.QSensorPluginInterface}</p>
     */
    public static abstract class Impl extends QtObject
        implements io.qt.sensors.QSensorPluginInterface
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @NativeAccess
        private static final class ConcreteWrapper extends QSensorPluginInterface.Impl {
            
            @NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @QtUninvokable
            public void registerSensors(){
                registerSensors_native(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static void registerSensors_native(long __this__nativeId);
            
        }
        
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qsensorplugininterface.html#registerSensors">QSensorPluginInterface::<wbr/>registerSensors()</a></code></p>
         */
        @QtUninvokable
        public abstract void registerSensors();
        
        private native static void registerSensors_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorplugininterface.html#registerSensors">QSensorPluginInterface::<wbr/>registerSensors()</a></code></p>
     */
    @QtUninvokable
    public void registerSensors();
    
}
