package io.qt.sensors;

import io.qt.*;


/**
 * <p>Sensor implementation</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsensorbackend.html">QSensorBackend</a></code></p>
 */
public abstract class QSensorBackend extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSensorBackend.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QSensorBackend {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public void start(){
            start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void start_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void stop(){
            stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void stop_native(long __this__nativeId);
        
    }
    
    
    /**
     * <p>See <code>QSensorBackend::<wbr/>QSensorBackend(QSensor*,<wbr/>QObject*)</code></p>
     */
    public QSensorBackend(io.qt.sensors.@Nullable QSensor sensor, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, sensor, parent);
    }
    
    private native static void initialize_native(QSensorBackend instance, io.qt.sensors.QSensor sensor, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#addDataRate">QSensorBackend::<wbr/>addDataRate(qreal,<wbr/>qreal)</a></code></p>
     */
    @QtUninvokable
    public final void addDataRate(double min, double max){
        addDataRate_native_qreal_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), min, max);
    }
    
    @QtUninvokable
    private native void addDataRate_native_qreal_qreal(long __this__nativeId, double min, double max);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#addOutputRange">QSensorBackend::<wbr/>addOutputRange(qreal,<wbr/>qreal,<wbr/>qreal)</a></code></p>
     */
    @QtUninvokable
    public final void addOutputRange(double min, double max, double accuracy){
        addOutputRange_native_qreal_qreal_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), min, max, accuracy);
    }
    
    @QtUninvokable
    private native void addOutputRange_native_qreal_qreal_qreal(long __this__nativeId, double min, double max, double accuracy);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#newReadingAvailable">QSensorBackend::<wbr/>newReadingAvailable()</a></code></p>
     */
    @QtUninvokable
    public final void newReadingAvailable(){
        newReadingAvailable_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void newReadingAvailable_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#reading">QSensorBackend::<wbr/>reading()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sensors.@Nullable QSensorReading reading(){
        return reading_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sensors.QSensorReading reading_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#sensor">QSensorBackend::<wbr/>sensor()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sensors.@Nullable QSensor sensor(){
        return sensor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sensors.QSensor sensor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#sensorBusy">QSensorBackend::<wbr/>sensorBusy(bool)</a></code></p>
     */
    @QtUninvokable
    public final void sensorBusy(boolean busy){
        sensorBusy_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), busy);
    }
    
    @QtUninvokable
    private native void sensorBusy_native_bool(long __this__nativeId, boolean busy);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#sensorError">QSensorBackend::<wbr/>sensorError(int)</a></code></p>
     */
    @QtUninvokable
    public final void sensorError(int error){
        sensorError_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), error);
    }
    
    @QtUninvokable
    private native void sensorError_native_int(long __this__nativeId, int error);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#sensorStopped">QSensorBackend::<wbr/>sensorStopped()</a></code></p>
     */
    @QtUninvokable
    public final void sensorStopped(){
        sensorStopped_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void sensorStopped_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#setDataRates">QSensorBackend::<wbr/>setDataRates(const QSensor*)</a></code></p>
     */
    @QtUninvokable
    public final void setDataRates(io.qt.sensors.@Nullable QSensor otherSensor){
        setDataRates_native_const_QSensor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(otherSensor));
    }
    
    @QtUninvokable
    private native void setDataRates_native_const_QSensor_ptr(long __this__nativeId, long otherSensor);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#setDescription">QSensorBackend::<wbr/>setDescription(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setDescription(java.lang.@NonNull String description){
        setDescription_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), description);
    }
    
    @QtUninvokable
    private native void setDescription_native_cref_QString(long __this__nativeId, java.lang.String description);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#setReading">QSensorBackend::<wbr/>setReading&lt;T&gt;(T*)</a></code></p>
     */
    @QtUninvokable
    public final <T extends io.qt.sensors.QSensorReading> @StrictNonNull T setReading(java.lang.@StrictNonNull Class<T> readingClass){
        java.util.Objects.requireNonNull(readingClass, "Argument 'readingClass': null not expected.");
        return setReading_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), readingClass);
    }
    
    @QtUninvokable
    private native <T extends io.qt.sensors.QSensorReading> T setReading_native_QObject_ptr(long __this__nativeId, java.lang.Class<T> readingClass);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#setReading">QSensorBackend::<wbr/>setReading&lt;T&gt;(T*)</a></code></p>
     */
    @QtUninvokable
    public final <T extends io.qt.sensors.QSensorReading> @StrictNonNull T setReading(@StrictNonNull T readingClass){
        java.util.Objects.requireNonNull(readingClass, "Argument 'readingClass': null not expected.");
        return setReading_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), readingClass);
    }
    
    @QtUninvokable
    private native <T extends io.qt.sensors.QSensorReading> T setReading_native_QSensorReading_ptr(long __this__nativeId, T readingClass);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#isFeatureSupported">QSensorBackend::<wbr/>isFeatureSupported(QSensor::Feature)const</a></code></p>
     */
    @QtUninvokable
    public boolean isFeatureSupported(io.qt.sensors.QSensor.@NonNull Feature feature){
        return isFeatureSupported_native_QSensor_Feature_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), feature.value());
    }
    
    @QtUninvokable
    private native boolean isFeatureSupported_native_QSensor_Feature_constfct(long __this__nativeId, int feature);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#start">QSensorBackend::<wbr/>start()</a></code></p>
     */
    @QtUninvokable
    public abstract void start();
    
    @QtUninvokable
    private native void start_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensorbackend.html#stop">QSensorBackend::<wbr/>stop()</a></code></p>
     */
    @QtUninvokable
    public abstract void stop();
    
    @QtUninvokable
    private native void stop_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSensorBackend(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded constructor for {@link #QSensorBackend(io.qt.sensors.QSensor, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSensorBackend(io.qt.sensors.@Nullable QSensor sensor) {
        this(sensor, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #sensorBusy(boolean)}
     *  with <code>busy = true</code>.</p>
     */
    @QtUninvokable
    public final void sensorBusy() {
        sensorBusy((boolean)true);
    }
}
