package io.qt.sensors;

import io.qt.*;


/**
 * <p>Holds readings from the tilt sensor</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qtiltreading.html">QTiltReading</a></code></p>
 */
public class QTiltReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QTiltReading.class);
    
    
    /**
     * <p>See <code>QTiltReading::<wbr>QTiltReading(QObject*)</code></p>
     */
    public QTiltReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QTiltReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qtiltreading.html#setXRotation">QTiltReading::<wbr>setXRotation(qreal)</a></code></p>
     */
    @QtUninvokable
    public final void setXRotation(double x){
        setXRotation_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), x);
    }
    
    @QtUninvokable
    private native void setXRotation_native_qreal(long __this__nativeId, double x);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qtiltreading.html#setYRotation">QTiltReading::<wbr>setYRotation(qreal)</a></code></p>
     */
    @QtUninvokable
    public final void setYRotation(double y){
        setYRotation_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), y);
    }
    
    @QtUninvokable
    private native void setYRotation_native_qreal(long __this__nativeId, double y);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qtiltreading.html#xRotation-prop">QTiltReading::<wbr>xRotation()const</a></code></p>
     */
    @QtPropertyReader(name="xRotation")
    @QtUninvokable
    public final double xRotation(){
        return xRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double xRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qtiltreading.html#yRotation-prop">QTiltReading::<wbr>yRotation()const</a></code></p>
     */
    @QtPropertyReader(name="yRotation")
    @QtUninvokable
    public final double yRotation(){
        return yRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double yRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QSensorReading::<wbr>copyValuesFrom(QSensorReading*)</code></p>
     */
    @QtUninvokable
    @Override
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QTiltReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QTiltReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QTiltReading instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QTiltReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QTiltReading() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #xRotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getXRotation() {
        return xRotation();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #yRotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getYRotation() {
        return yRotation();
    }
}
