package io.qt.sensors;

import io.qt.*;


/**
 * <p>Represents one reading from the light sensor</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qlightreading.html">QLightReading</a></code></p>
 */
public class QLightReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QLightReading.class);
    
    
    /**
     * <p>See <code>QLightReading::<wbr>QLightReading(QObject*)</code></p>
     */
    public QLightReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QLightReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qlightreading.html#lux-prop">QLightReading::<wbr>lux()const</a></code></p>
     */
    @QtPropertyReader(name="lux")
    @QtUninvokable
    public final double lux(){
        return lux_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double lux_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qlightreading.html#setLux">QLightReading::<wbr>setLux(qreal)</a></code></p>
     */
    @QtUninvokable
    public final void setLux(double lux){
        setLux_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), lux);
    }
    
    @QtUninvokable
    private native void setLux_native_qreal(long __this__nativeId, double lux);
    
    /**
     * <p>See <code>QSensorReading::<wbr>copyValuesFrom(QSensorReading*)</code></p>
     */
    @QtUninvokable
    @Override
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QLightReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QLightReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QLightReading instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QLightReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QLightReading() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #lux()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getLux() {
        return lux();
    }
}
