package io.qt.sensors;

import io.qt.*;


/**
 * <p>Represents one reading from the ambient light sensor</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qambientlightreading.html">QAmbientLightReading</a></code></p>
 */
public class QAmbientLightReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAmbientLightReading.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qambientlightreading.html#LightLevel-enum">QAmbientLightReading::LightLevel</a></code></p>
     */
    public enum LightLevel implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qambientlightreading.html#LightLevel-enum">QAmbientLightReading::<wbr>Undefined</a></code></p>
         */
        Undefined(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qambientlightreading.html#LightLevel-enum">QAmbientLightReading::<wbr>Dark</a></code></p>
         */
        Dark(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qambientlightreading.html#LightLevel-enum">QAmbientLightReading::<wbr>Twilight</a></code></p>
         */
        Twilight(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qambientlightreading.html#LightLevel-enum">QAmbientLightReading::<wbr>Light</a></code></p>
         */
        Light(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qambientlightreading.html#LightLevel-enum">QAmbientLightReading::<wbr>Bright</a></code></p>
         */
        Bright(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qambientlightreading.html#LightLevel-enum">QAmbientLightReading::<wbr>Sunny</a></code></p>
         */
        Sunny(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private LightLevel(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull LightLevel resolve(int value) {
            switch (value) {
            case 0: return Undefined;
            case 1: return Dark;
            case 2: return Twilight;
            case 3: return Light;
            case 4: return Bright;
            case 5: return Sunny;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code>QAmbientLightReading::<wbr>QAmbientLightReading(QObject*)</code></p>
     */
    public QAmbientLightReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAmbientLightReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientlightreading.html#lightLevel-prop">QAmbientLightReading::<wbr>lightLevel()const</a></code></p>
     */
    @QtPropertyReader(name="lightLevel")
    @QtUninvokable
    public final io.qt.sensors.QAmbientLightReading.@NonNull LightLevel lightLevel(){
        return io.qt.sensors.QAmbientLightReading.LightLevel.resolve(lightLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int lightLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambientlightreading.html#setLightLevel">QAmbientLightReading::<wbr>setLightLevel(QAmbientLightReading::LightLevel)</a></code></p>
     */
    @QtUninvokable
    public final void setLightLevel(io.qt.sensors.QAmbientLightReading.@NonNull LightLevel lightLevel){
        setLightLevel_native_QAmbientLightReading_LightLevel(QtJambi_LibraryUtilities.internal.nativeId(this), lightLevel.value());
    }
    
    @QtUninvokable
    private native void setLightLevel_native_QAmbientLightReading_LightLevel(long __this__nativeId, int lightLevel);
    
    /**
     * <p>See <code>QSensorReading::<wbr>copyValuesFrom(QSensorReading*)</code></p>
     */
    @QtUninvokable
    @Override
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAmbientLightReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAmbientLightReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAmbientLightReading instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAmbientLightReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAmbientLightReading() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #lightLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.sensors.QAmbientLightReading.@NonNull LightLevel getLightLevel() {
        return lightLevel();
    }
}
