package io.qt.sensors;

import io.qt.*;


/**
 * <p>Java wrapper for Qt class <code>QTapReading</code></p>
 */
public class QTapReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QTapReading.class);
    
    /**
     * <p>Java wrapper for Qt enum <code>QTapReading::TapDirection</code></p>
     */
    public enum TapDirection implements QtEnumerator {
        /**
         * <p>Representing <code>QTapReading::<wbr>Undefined</code></p>
         */
        Undefined(0),
        /**
         * <p>Representing <code>QTapReading::<wbr>X</code></p>
         */
        X(1),
        /**
         * <p>Representing <code>QTapReading::<wbr>Y</code></p>
         */
        Y(2),
        /**
         * <p>Representing <code>QTapReading::<wbr>Z</code></p>
         */
        Z(4),
        /**
         * <p>Representing <code>QTapReading::<wbr>X_Pos</code></p>
         */
        X_Pos(17),
        /**
         * <p>Representing <code>QTapReading::<wbr>Y_Pos</code></p>
         */
        Y_Pos(34),
        /**
         * <p>Representing <code>QTapReading::<wbr>Z_Pos</code></p>
         */
        Z_Pos(68),
        /**
         * <p>Representing <code>QTapReading::<wbr>X_Neg</code></p>
         */
        X_Neg(257),
        /**
         * <p>Representing <code>QTapReading::<wbr>Y_Neg</code></p>
         */
        Y_Neg(514),
        /**
         * <p>Representing <code>QTapReading::<wbr>Z_Neg</code></p>
         */
        Z_Neg(1028),
        /**
         * <p>Representing <code>QTapReading::<wbr>X_Both</code></p>
         */
        X_Both(273),
        /**
         * <p>Representing <code>QTapReading::<wbr>Y_Both</code></p>
         */
        Y_Both(546),
        /**
         * <p>Representing <code>QTapReading::<wbr>Z_Both</code></p>
         */
        Z_Both(1092);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TapDirection(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TapDirection resolve(int value) {
            switch (value) {
            case 0: return Undefined;
            case 1: return X;
            case 2: return Y;
            case 4: return Z;
            case 17: return X_Pos;
            case 34: return Y_Pos;
            case 68: return Z_Pos;
            case 257: return X_Neg;
            case 514: return Y_Neg;
            case 1028: return Z_Neg;
            case 273: return X_Both;
            case 546: return Y_Both;
            case 1092: return Z_Both;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QTapReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QTapReading() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code>QTapReading::<wbr>QTapReading(QObject*)</code></p>
     */
    public QTapReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QTapReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isDoubleTap()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getDoubleTap() {
        return isDoubleTap();
    }
    
    /**
     * <p>See <code>QTapReading::<wbr>isDoubleTap()const</code></p>
     */
    @QtPropertyReader(name="doubleTap")
    @QtUninvokable
    public final boolean isDoubleTap(){
        return isDoubleTap_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isDoubleTap_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QTapReading::<wbr>setDoubleTap(bool)</code></p>
     */
    @QtUninvokable
    public final void setDoubleTap(boolean doubleTap){
        setDoubleTap_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), doubleTap);
    }
    
    @QtUninvokable
    private native void setDoubleTap_native_bool(long __this__nativeId, boolean doubleTap);
    
    /**
     * <p>See <code>QTapReading::<wbr>setTapDirection(QTapReading::TapDirection)</code></p>
     */
    @QtUninvokable
    public final void setTapDirection(io.qt.sensors.QTapReading.@NonNull TapDirection tapDirection){
        setTapDirection_native_QTapReading_TapDirection(QtJambi_LibraryUtilities.internal.nativeId(this), tapDirection.value());
    }
    
    @QtUninvokable
    private native void setTapDirection_native_QTapReading_TapDirection(long __this__nativeId, int tapDirection);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #tapDirection()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.sensors.QTapReading.@NonNull TapDirection getTapDirection() {
        return tapDirection();
    }
    
    /**
     * <p>See <code>QTapReading::<wbr>tapDirection()const</code></p>
     */
    @QtPropertyReader(name="tapDirection")
    @QtUninvokable
    public final io.qt.sensors.QTapReading.@NonNull TapDirection tapDirection(){
        return io.qt.sensors.QTapReading.TapDirection.resolve(tapDirection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int tapDirection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QSensorReading::<wbr>copyValuesFrom(QSensorReading*)</code></p>
     */
    @QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QTapReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QTapReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QTapReading instance, QDeclarativeConstructor constructor);
    
}
