package io.qt.sensors;

import io.qt.*;


/**
 * <p>Represents a single hardware sensor</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsensor.html">QSensor</a></code></p>
 */
public class QSensor extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcFilters;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSensor.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qsensor.html#AxesOrientationMode-enum">QSensor::AxesOrientationMode</a></code></p>
     */
    public enum AxesOrientationMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsensor.html#AxesOrientationMode-enum">QSensor::<wbr>FixedOrientation</a></code></p>
         */
        FixedOrientation(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsensor.html#AxesOrientationMode-enum">QSensor::<wbr>AutomaticOrientation</a></code></p>
         */
        AutomaticOrientation(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsensor.html#AxesOrientationMode-enum">QSensor::<wbr>UserOrientation</a></code></p>
         */
        UserOrientation(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AxesOrientationMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull AxesOrientationMode resolve(int value) {
            switch (value) {
            case 0: return FixedOrientation;
            case 1: return AutomaticOrientation;
            case 2: return UserOrientation;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qsensor.html#Feature-enum">QSensor::Feature</a></code></p>
     */
    public enum Feature implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsensor.html#Feature-enum">QSensor::<wbr>Buffering</a></code></p>
         */
        Buffering(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsensor.html#Feature-enum">QSensor::<wbr>AlwaysOn</a></code></p>
         */
        AlwaysOn(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsensor.html#Feature-enum">QSensor::<wbr>GeoValues</a></code></p>
         */
        GeoValues(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsensor.html#Feature-enum">QSensor::<wbr>FieldOfView</a></code></p>
         */
        FieldOfView(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsensor.html#Feature-enum">QSensor::<wbr>AccelerationMode</a></code></p>
         */
        AccelerationMode(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsensor.html#Feature-enum">QSensor::<wbr>SkipDuplicates</a></code></p>
         */
        SkipDuplicates(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsensor.html#Feature-enum">QSensor::<wbr>AxesOrientation</a></code></p>
         */
        AxesOrientation(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsensor.html#Feature-enum">QSensor::<wbr>PressureSensorTemperature</a></code></p>
         */
        PressureSensorTemperature(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsensor.html#Feature-enum">QSensor::<wbr>Reserved</a></code></p>
         */
        Reserved(257);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Feature(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Feature resolve(int value) {
            switch (value) {
            case 0: return Buffering;
            case 1: return AlwaysOn;
            case 2: return GeoValues;
            case 3: return FieldOfView;
            case 4: return AccelerationMode;
            case 5: return SkipDuplicates;
            case 6: return AxesOrientation;
            case 7: return PressureSensorTemperature;
            case 257: return Reserved;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#activeChanged">QSensor::<wbr>activeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="active")
    public final @NonNull Signal0 activeChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#alwaysOnChanged">QSensor::<wbr>alwaysOnChanged()</a></code></p>
     */
    @QtPropertyNotify(name="alwaysOn")
    public final @NonNull Signal0 alwaysOnChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#availableSensorsChanged">QSensor::<wbr>availableSensorsChanged()</a></code></p>
     */
    public final @NonNull Signal0 availableSensorsChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#axesOrientationMode-prop">QSensor::<wbr>axesOrientationModeChanged(QSensor::AxesOrientationMode)</a></code></p>
     */
    @QtPropertyNotify(name="axesOrientationMode")
    public final @NonNull Signal1<io.qt.sensors.QSensor.@NonNull AxesOrientationMode> axesOrientationModeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#bufferSize-prop">QSensor::<wbr>bufferSizeChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="bufferSize")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> bufferSizeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#busyChanged">QSensor::<wbr>busyChanged()</a></code></p>
     */
    @QtPropertyNotify(name="busy")
    public final @NonNull Signal0 busyChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#currentOrientation-prop">QSensor::<wbr>currentOrientationChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="currentOrientation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> currentOrientationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#dataRate-prop">QSensor::<wbr>dataRateChanged()</a></code></p>
     */
    @QtPropertyNotify(name="dataRate")
    public final @NonNull Signal0 dataRateChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#efficientBufferSize-prop">QSensor::<wbr>efficientBufferSizeChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="efficientBufferSize")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> efficientBufferSizeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#identifier-prop">QSensor::<wbr>identifierChanged()</a></code></p>
     */
    @QtPropertyNotify(name="identifier")
    public final @NonNull Signal0 identifierChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#maxBufferSize-prop">QSensor::<wbr>maxBufferSizeChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="maxBufferSize")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> maxBufferSizeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#readingChanged">QSensor::<wbr>readingChanged()</a></code></p>
     */
    @QtPropertyNotify(name="reading")
    public final @NonNull Signal0 readingChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#sensorError">QSensor::<wbr>sensorError(int)</a></code></p>
     */
    @QtPropertyNotify(name="error")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> sensorError = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#skipDuplicatesChanged">QSensor::<wbr>skipDuplicatesChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="skipDuplicates")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> skipDuplicatesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#userOrientation-prop">QSensor::<wbr>userOrientationChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="userOrientation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> userOrientationChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QSensor(io.qt.core.QByteArray, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSensor(io.qt.core.@NonNull QByteArray type) {
        this(type, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#QSensor">QSensor::<wbr>QSensor(QByteArray,<wbr>QObject*)</a></code></p>
     */
    public QSensor(io.qt.core.@NonNull QByteArray type, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, type, parent);
    }
    
    private native static void initialize_native(QSensor instance, io.qt.core.QByteArray type, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#addFilter">QSensor::<wbr>addFilter(QSensorFilter*)</a></code></p>
     */
    @QtUninvokable
    public final void addFilter(io.qt.sensors.@Nullable QSensorFilter filter){
        addFilter_native_QSensorFilter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(filter));
        if (filter != null) {
            if(__rcFilters==null)
                __rcFilters = QtJambi_LibraryUtilities.internal.newRCList();
            __rcFilters.add(filter);
        }
    }
    
    @QtUninvokable
    private native void addFilter_native_QSensorFilter_ptr(long __this__nativeId, long filter);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #availableDataRates()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@NonNull QPair<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer>> getAvailableDataRates() {
        return availableDataRates();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#availableDataRates-prop">QSensor::<wbr>availableDataRates()const</a></code></p>
     */
    @QtPropertyReader(name="availableDataRates")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@NonNull QPair<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer>> availableDataRates(){
        return availableDataRates_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.core.QPair<java.lang.@QtPrimitiveType Integer, java.lang.@QtPrimitiveType Integer>> availableDataRates_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #axesOrientationMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.sensors.QSensor.@NonNull AxesOrientationMode getAxesOrientationMode() {
        return axesOrientationMode();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#axesOrientationMode-prop">QSensor::<wbr>axesOrientationMode()const</a></code></p>
     */
    @QtPropertyReader(name="axesOrientationMode")
    @QtUninvokable
    public final io.qt.sensors.QSensor.@NonNull AxesOrientationMode axesOrientationMode(){
        return io.qt.sensors.QSensor.AxesOrientationMode.resolve(axesOrientationMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int axesOrientationMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QSensor::<wbr>backend()const</code></p>
     */
    @QtUninvokable
    protected final io.qt.sensors.@Nullable QSensorBackend backend(){
        return backend_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sensors.QSensorBackend backend_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #bufferSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getBufferSize() {
        return bufferSize();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#bufferSize-prop">QSensor::<wbr>bufferSize()const</a></code></p>
     */
    @QtPropertyReader(name="bufferSize")
    @QtUninvokable
    public final int bufferSize(){
        return bufferSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int bufferSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#connectToBackend">QSensor::<wbr>connectToBackend()</a></code></p>
     */
    public final boolean connectToBackend(){
        return connectToBackend_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean connectToBackend_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #currentOrientation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getCurrentOrientation() {
        return currentOrientation();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#currentOrientation-prop">QSensor::<wbr>currentOrientation()const</a></code></p>
     */
    @QtPropertyReader(name="currentOrientation")
    @QtUninvokable
    public final int currentOrientation(){
        return currentOrientation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int currentOrientation_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #dataRate()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getDataRate() {
        return dataRate();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#dataRate-prop">QSensor::<wbr>dataRate()const</a></code></p>
     */
    @QtPropertyReader(name="dataRate")
    @QtUninvokable
    public final int dataRate(){
        return dataRate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int dataRate_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #description()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getDescription() {
        return description();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#description-prop">QSensor::<wbr>description()const</a></code></p>
     */
    @QtPropertyReader(name="description")
    @QtUninvokable
    public final java.lang.@NonNull String description(){
        return description_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String description_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #efficientBufferSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getEfficientBufferSize() {
        return efficientBufferSize();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#efficientBufferSize-prop">QSensor::<wbr>efficientBufferSize()const</a></code></p>
     */
    @QtPropertyReader(name="efficientBufferSize")
    @QtUninvokable
    public final int efficientBufferSize(){
        return efficientBufferSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int efficientBufferSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #error()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getError() {
        return error();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#error-prop">QSensor::<wbr>error()const</a></code></p>
     */
    @QtPropertyReader(name="error")
    @QtUninvokable
    public final int error(){
        return error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#filters">QSensor::<wbr>filters()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.sensors.@Nullable QSensorFilter> filters(){
        return filters_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.sensors.QSensorFilter> filters_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #identifier()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getIdentifier() {
        return identifier();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#identifier-prop">QSensor::<wbr>identifier()const</a></code></p>
     */
    @QtPropertyReader(name="identifier")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray identifier(){
        return identifier_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray identifier_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isActive()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getActive() {
        return isActive();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#active-prop">QSensor::<wbr>isActive()const</a></code></p>
     */
    @QtPropertyReader(name="active")
    @QtUninvokable
    public final boolean isActive(){
        return isActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isAlwaysOn()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAlwaysOn() {
        return isAlwaysOn();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#alwaysOn-prop">QSensor::<wbr>isAlwaysOn()const</a></code></p>
     */
    @QtPropertyReader(name="alwaysOn")
    @QtUninvokable
    public final boolean isAlwaysOn(){
        return isAlwaysOn_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAlwaysOn_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isBusy()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getBusy() {
        return isBusy();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#busy-prop">QSensor::<wbr>isBusy()const</a></code></p>
     */
    @QtPropertyReader(name="busy")
    @QtUninvokable
    public final boolean isBusy(){
        return isBusy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isBusy_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isConnectedToBackend()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getConnectedToBackend() {
        return isConnectedToBackend();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#connectedToBackend-prop">QSensor::<wbr>isConnectedToBackend()const</a></code></p>
     */
    @QtPropertyReader(name="connectedToBackend")
    @QtUninvokable
    public final boolean isConnectedToBackend(){
        return isConnectedToBackend_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isConnectedToBackend_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#isFeatureSupported">QSensor::<wbr>isFeatureSupported(QSensor::Feature)const</a></code></p>
     */
    public final boolean isFeatureSupported(io.qt.sensors.QSensor.@NonNull Feature feature){
        return isFeatureSupported_native_QSensor_Feature_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), feature.value());
    }
    
    private native boolean isFeatureSupported_native_QSensor_Feature_constfct(long __this__nativeId, int feature);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxBufferSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxBufferSize() {
        return maxBufferSize();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#maxBufferSize-prop">QSensor::<wbr>maxBufferSize()const</a></code></p>
     */
    @QtPropertyReader(name="maxBufferSize")
    @QtUninvokable
    public final int maxBufferSize(){
        return maxBufferSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxBufferSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #outputRange()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getOutputRange() {
        return outputRange();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#outputRange-prop">QSensor::<wbr>outputRange()const</a></code></p>
     */
    @QtPropertyReader(name="outputRange")
    @QtUninvokable
    public final int outputRange(){
        return outputRange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int outputRange_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #outputRanges()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.sensors.@NonNull QOutputRange> getOutputRanges() {
        return outputRanges();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#outputRanges-prop">QSensor::<wbr>outputRanges()const</a></code></p>
     */
    @QtPropertyReader(name="outputRanges")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.sensors.@NonNull QOutputRange> outputRanges(){
        return outputRanges_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.sensors.QOutputRange> outputRanges_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #reading()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtDeclaredFinal
    @QtUninvokable
    public final io.qt.sensors.@Nullable QSensorReading getReading() {
        return reading();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#reading-prop">QSensor::<wbr>reading()const</a></code></p>
     */
    @QtPropertyReader(name="reading")
    @QtDeclaredFinal
    @QtUninvokable
    public io.qt.sensors.@Nullable QSensorReading reading(){
        return reading_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sensors.QSensorReading reading_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#removeFilter">QSensor::<wbr>removeFilter(QSensorFilter*)</a></code></p>
     */
    @QtUninvokable
    public final void removeFilter(io.qt.sensors.@Nullable QSensorFilter filter){
        removeFilter_native_QSensorFilter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(filter));
        if (filter != null) {
            while (__rcFilters != null && __rcFilters.remove(filter)) ;
        }
    }
    
    @QtUninvokable
    private native void removeFilter_native_QSensorFilter_ptr(long __this__nativeId, long filter);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#active-prop">QSensor::<wbr>setActive(bool)</a></code></p>
     */
    @QtPropertyWriter(name="active")
    @QtUninvokable
    public final void setActive(boolean active){
        setActive_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), active);
    }
    
    @QtUninvokable
    private native void setActive_native_bool(long __this__nativeId, boolean active);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#alwaysOn-prop">QSensor::<wbr>setAlwaysOn(bool)</a></code></p>
     */
    @QtPropertyWriter(name="alwaysOn")
    @QtUninvokable
    public final void setAlwaysOn(boolean alwaysOn){
        setAlwaysOn_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), alwaysOn);
    }
    
    @QtUninvokable
    private native void setAlwaysOn_native_bool(long __this__nativeId, boolean alwaysOn);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#axesOrientationMode-prop">QSensor::<wbr>setAxesOrientationMode(QSensor::AxesOrientationMode)</a></code></p>
     */
    @QtPropertyWriter(name="axesOrientationMode")
    @QtUninvokable
    public final void setAxesOrientationMode(io.qt.sensors.QSensor.@NonNull AxesOrientationMode axesOrientationMode){
        setAxesOrientationMode_native_QSensor_AxesOrientationMode(QtJambi_LibraryUtilities.internal.nativeId(this), axesOrientationMode.value());
    }
    
    @QtUninvokable
    private native void setAxesOrientationMode_native_QSensor_AxesOrientationMode(long __this__nativeId, int axesOrientationMode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#bufferSize-prop">QSensor::<wbr>setBufferSize(int)</a></code></p>
     */
    @QtPropertyWriter(name="bufferSize")
    @QtUninvokable
    public final void setBufferSize(int bufferSize){
        setBufferSize_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), bufferSize);
    }
    
    @QtUninvokable
    private native void setBufferSize_native_int(long __this__nativeId, int bufferSize);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#setCurrentOrientation">QSensor::<wbr>setCurrentOrientation(int)</a></code></p>
     */
    @QtUninvokable
    public final void setCurrentOrientation(int currentOrientation){
        setCurrentOrientation_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), currentOrientation);
    }
    
    @QtUninvokable
    private native void setCurrentOrientation_native_int(long __this__nativeId, int currentOrientation);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#dataRate-prop">QSensor::<wbr>setDataRate(int)</a></code></p>
     */
    @QtPropertyWriter(name="dataRate")
    @QtUninvokable
    public final void setDataRate(int rate){
        setDataRate_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), rate);
    }
    
    @QtUninvokable
    private native void setDataRate_native_int(long __this__nativeId, int rate);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#setEfficientBufferSize">QSensor::<wbr>setEfficientBufferSize(int)</a></code></p>
     */
    @QtUninvokable
    public final void setEfficientBufferSize(int efficientBufferSize){
        setEfficientBufferSize_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), efficientBufferSize);
    }
    
    @QtUninvokable
    private native void setEfficientBufferSize_native_int(long __this__nativeId, int efficientBufferSize);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#identifier-prop">QSensor::<wbr>setIdentifier(QByteArray)</a></code></p>
     */
    @QtPropertyWriter(name="identifier")
    @QtUninvokable
    public final void setIdentifier(io.qt.core.@NonNull QByteArray identifier){
        setIdentifier_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(identifier));
    }
    
    @QtUninvokable
    private native void setIdentifier_native_cref_QByteArray(long __this__nativeId, long identifier);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#setMaxBufferSize">QSensor::<wbr>setMaxBufferSize(int)</a></code></p>
     */
    @QtUninvokable
    public final void setMaxBufferSize(int maxBufferSize){
        setMaxBufferSize_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), maxBufferSize);
    }
    
    @QtUninvokable
    private native void setMaxBufferSize_native_int(long __this__nativeId, int maxBufferSize);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#outputRange-prop">QSensor::<wbr>setOutputRange(int)</a></code></p>
     */
    @QtPropertyWriter(name="outputRange")
    @QtUninvokable
    public final void setOutputRange(int index){
        setOutputRange_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void setOutputRange_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#setSkipDuplicates">QSensor::<wbr>setSkipDuplicates(bool)</a></code></p>
     */
    @QtPropertyWriter(name="skipDuplicates")
    @QtUninvokable
    public final void setSkipDuplicates(boolean skipDuplicates){
        setSkipDuplicates_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), skipDuplicates);
    }
    
    @QtUninvokable
    private native void setSkipDuplicates_native_bool(long __this__nativeId, boolean skipDuplicates);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#userOrientation-prop">QSensor::<wbr>setUserOrientation(int)</a></code></p>
     */
    @QtPropertyWriter(name="userOrientation")
    @QtUninvokable
    public final void setUserOrientation(int userOrientation){
        setUserOrientation_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), userOrientation);
    }
    
    @QtUninvokable
    private native void setUserOrientation_native_int(long __this__nativeId, int userOrientation);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #skipDuplicates()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSkipDuplicates() {
        return skipDuplicates();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#skipDuplicates-prop">QSensor::<wbr>skipDuplicates()const</a></code></p>
     */
    @QtPropertyReader(name="skipDuplicates")
    @QtUninvokable
    public final boolean skipDuplicates(){
        return skipDuplicates_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean skipDuplicates_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#start">QSensor::<wbr>start()</a></code></p>
     */
    public final boolean start(){
        return start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean start_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#stop">QSensor::<wbr>stop()</a></code></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #type()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getType() {
        return type();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#type-prop">QSensor::<wbr>type()const</a></code></p>
     */
    @QtPropertyReader(name="type")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray type(){
        return type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray type_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #userOrientation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getUserOrientation() {
        return userOrientation();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#userOrientation-prop">QSensor::<wbr>userOrientation()const</a></code></p>
     */
    @QtPropertyReader(name="userOrientation")
    @QtUninvokable
    public final int userOrientation(){
        return userOrientation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int userOrientation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#defaultSensorForType">QSensor::<wbr>defaultSensorForType(QByteArray)</a></code></p>
     */
    public static io.qt.core.@NonNull QByteArray defaultSensorForType(io.qt.core.@NonNull QByteArray type){
        return defaultSensorForType_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.checkedNativeId(type));
    }
    
    private native static io.qt.core.QByteArray defaultSensorForType_native_cref_QByteArray(long type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#sensorTypes">QSensor::<wbr>sensorTypes()</a></code></p>
     */
    public native static io.qt.core.@NonNull QList<io.qt.core.@NonNull QByteArray> sensorTypes();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsensor.html#sensorsForType">QSensor::<wbr>sensorsForType(QByteArray)</a></code></p>
     */
    public static io.qt.core.@NonNull QList<io.qt.core.@NonNull QByteArray> sensorsForType(io.qt.core.@NonNull QByteArray type){
        return sensorsForType_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.checkedNativeId(type));
    }
    
    private native static io.qt.core.QList<io.qt.core.QByteArray> sensorsForType_native_cref_QByteArray(long type);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSensor(QPrivateConstructor p) { super(p); } 
    
}
