package io.qt.sensors;

import io.qt.*;


/**
 * <p>Represents one reading from the proximity sensor</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qproximityreading.html">QProximityReading</a></code></p>
 */
public class QProximityReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QProximityReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QProximityReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QProximityReading() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code>QProximityReading::<wbr>QProximityReading(QObject*)</code></p>
     */
    public QProximityReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QProximityReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #close()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getClose() {
        return close();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qproximityreading.html#close-prop">QProximityReading::<wbr>close()const</a></code></p>
     */
    @QtPropertyReader(name="close")
    @QtUninvokable
    public final boolean close(){
        return close_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean close_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qproximityreading.html#setClose">QProximityReading::<wbr>setClose(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setClose(boolean close){
        setClose_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), close);
    }
    
    @QtUninvokable
    private native void setClose_native_bool(long __this__nativeId, boolean close);
    
    /**
     * <p>See <code>QSensorReading::<wbr>copyValuesFrom(QSensorReading*)</code></p>
     */
    @QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QProximityReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QProximityReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QProximityReading instance, QDeclarativeConstructor constructor);
    
}
