package io.qt.sensors;

import io.qt.*;


/**
 * <p>Holds the specifics of an output range</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qoutputrange.html">qoutputrange</a></code></p>
 */
public class QOutputRange extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code>qoutputrange::<wbr>qoutputrange()</code></p>
     */
    public QOutputRange(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOutputRange instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoutputrange.html#accuracy-var">qoutputrange::<wbr>accuracy</a></code></p>
     */
    @QtUninvokable
    public final void setAccuracy(double accuracy){
        setAccuracy_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), accuracy);
    }
    
    @QtUninvokable
    private native void setAccuracy_native_qreal(long __this__nativeId, double accuracy);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #accuracy()} instead.</p>
     */
    @QtUninvokable
    public final double getAccuracy() {
        return accuracy();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoutputrange.html#accuracy-var">qoutputrange::<wbr>accuracy</a></code></p>
     */
    @QtUninvokable
    public final double accuracy(){
        return accuracy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double accuracy_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoutputrange.html#maximum-var">qoutputrange::<wbr>maximum</a></code></p>
     */
    @QtUninvokable
    public final void setMaximum(double maximum){
        setMaximum_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), maximum);
    }
    
    @QtUninvokable
    private native void setMaximum_native_qreal(long __this__nativeId, double maximum);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maximum()} instead.</p>
     */
    @QtUninvokable
    public final double getMaximum() {
        return maximum();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoutputrange.html#maximum-var">qoutputrange::<wbr>maximum</a></code></p>
     */
    @QtUninvokable
    public final double maximum(){
        return maximum_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double maximum_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoutputrange.html#minimum-var">qoutputrange::<wbr>minimum</a></code></p>
     */
    @QtUninvokable
    public final void setMinimum(double minimum){
        setMinimum_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), minimum);
    }
    
    @QtUninvokable
    private native void setMinimum_native_qreal(long __this__nativeId, double minimum);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minimum()} instead.</p>
     */
    @QtUninvokable
    public final double getMinimum() {
        return minimum();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoutputrange.html#minimum-var">qoutputrange::<wbr>minimum</a></code></p>
     */
    @QtUninvokable
    public final double minimum(){
        return minimum_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double minimum_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOutputRange(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QOutputRange clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QOutputRange clone_native(long __this_nativeId);
}
