package io.qt.sensors;

import io.qt.*;


/**
 * <p>Holds readings of the ambient temperature</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qambienttemperaturereading.html">QAmbientTemperatureReading</a></code></p>
 */
public class QAmbientTemperatureReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAmbientTemperatureReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAmbientTemperatureReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAmbientTemperatureReading() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code>QAmbientTemperatureReading::<wbr>QAmbientTemperatureReading(QObject*)</code></p>
     */
    public QAmbientTemperatureReading(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAmbientTemperatureReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambienttemperaturereading.html#setTemperature">QAmbientTemperatureReading::<wbr>setTemperature(qreal)</a></code></p>
     */
    @QtUninvokable
    public final void setTemperature(double temperature){
        setTemperature_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), temperature);
    }
    
    @QtUninvokable
    private native void setTemperature_native_qreal(long __this__nativeId, double temperature);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #temperature()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getTemperature() {
        return temperature();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qambienttemperaturereading.html#temperature-prop">QAmbientTemperatureReading::<wbr>temperature()const</a></code></p>
     */
    @QtPropertyReader(name="temperature")
    @QtUninvokable
    public final double temperature(){
        return temperature_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double temperature_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QSensorReading::<wbr>copyValuesFrom(QSensorReading*)</code></p>
     */
    @QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.@Nullable QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAmbientTemperatureReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAmbientTemperatureReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAmbientTemperatureReading instance, QDeclarativeConstructor constructor);
    
}
