package io.qt.sensors;


/**
 * <p>Represents a single hardware sensor</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsensor.html">QSensor</a></p>
 */
public class QSensor extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcFilters;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSensor.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsensor.html#AxesOrientationMode-enum">QSensor::AxesOrientationMode</a></p>
     */
    public enum AxesOrientationMode implements io.qt.QtEnumerator {
        FixedOrientation(0),
        AutomaticOrientation(1),
        UserOrientation(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AxesOrientationMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AxesOrientationMode resolve(int value) {
            switch (value) {
            case 0: return FixedOrientation;
            case 1: return AutomaticOrientation;
            case 2: return UserOrientation;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsensor.html#Feature-enum">QSensor::Feature</a></p>
     */
    public enum Feature implements io.qt.QtEnumerator {
        Buffering(0),
        AlwaysOn(1),
        GeoValues(2),
        FieldOfView(3),
        AccelerationMode(4),
        SkipDuplicates(5),
        AxesOrientation(6),
        PressureSensorTemperature(7),
        Reserved(257);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Feature(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Feature resolve(int value) {
            switch (value) {
            case 0: return Buffering;
            case 1: return AlwaysOn;
            case 2: return GeoValues;
            case 3: return FieldOfView;
            case 4: return AccelerationMode;
            case 5: return SkipDuplicates;
            case 6: return AxesOrientation;
            case 7: return PressureSensorTemperature;
            case 257: return Reserved;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#activeChanged">QSensor::activeChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="active")
    public final Signal0 activeChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#alwaysOnChanged">QSensor::alwaysOnChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="alwaysOn")
    public final Signal0 alwaysOnChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#availableSensorsChanged">QSensor::availableSensorsChanged()</a></p>
     */
    public final Signal0 availableSensorsChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#axesOrientationMode-prop">QSensor::axesOrientationModeChanged(QSensor::AxesOrientationMode)</a></p>
     */
    @io.qt.QtPropertyNotify(name="axesOrientationMode")
    public final Signal1<io.qt.sensors.QSensor.AxesOrientationMode> axesOrientationModeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#bufferSize-prop">QSensor::bufferSizeChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="bufferSize")
    public final Signal1<@io.qt.QtPrimitiveType Integer> bufferSizeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#busyChanged">QSensor::busyChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="busy")
    public final Signal0 busyChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#currentOrientation-prop">QSensor::currentOrientationChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="currentOrientation")
    public final Signal1<@io.qt.QtPrimitiveType Integer> currentOrientationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#dataRate-prop">QSensor::dataRateChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="dataRate")
    public final Signal0 dataRateChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#efficientBufferSize-prop">QSensor::efficientBufferSizeChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="efficientBufferSize")
    public final Signal1<@io.qt.QtPrimitiveType Integer> efficientBufferSizeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#identifier-prop">QSensor::identifierChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="identifier")
    public final Signal0 identifierChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#maxBufferSize-prop">QSensor::maxBufferSizeChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="maxBufferSize")
    public final Signal1<@io.qt.QtPrimitiveType Integer> maxBufferSizeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#readingChanged">QSensor::readingChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="reading")
    public final Signal0 readingChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#sensorError">QSensor::sensorError(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="error")
    public final Signal1<@io.qt.QtPrimitiveType Integer> sensorError = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#skipDuplicatesChanged">QSensor::skipDuplicatesChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="skipDuplicates")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> skipDuplicatesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#userOrientation-prop">QSensor::userOrientationChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="userOrientation")
    public final Signal1<@io.qt.QtPrimitiveType Integer> userOrientationChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QSensor(io.qt.core.QByteArray, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSensor(io.qt.core.QByteArray type) {
        this(type, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#QSensor">QSensor::QSensor(QByteArray,QObject*)</a></p>
     */
    public QSensor(io.qt.core.QByteArray type, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, type, parent);
    }
    
    private native static void initialize_native(QSensor instance, io.qt.core.QByteArray type, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#addFilter">QSensor::addFilter(QSensorFilter*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addFilter(io.qt.sensors.QSensorFilter filter){
        addFilter_native_QSensorFilter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(filter));
        if (filter != null) {
            if(__rcFilters==null)
                __rcFilters = QtJambi_LibraryUtilities.internal.newRCList();
            __rcFilters.add(filter);
        }
    }
    
    @io.qt.QtUninvokable
    private native void addFilter_native_QSensorFilter_ptr(long __this__nativeId, long filter);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#availableDataRates-prop">QSensor::availableDataRates()const</a></p>
     */
    @io.qt.QtPropertyReader(name="availableDataRates")
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.core.QPair<java.lang.Integer, java.lang.Integer>> availableDataRates(){
        return availableDataRates_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.core.QPair<java.lang.Integer, java.lang.Integer>> availableDataRates_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#axesOrientationMode-prop">QSensor::axesOrientationMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="axesOrientationMode")
    @io.qt.QtUninvokable
    public final io.qt.sensors.QSensor.AxesOrientationMode axesOrientationMode(){
        return io.qt.sensors.QSensor.AxesOrientationMode.resolve(axesOrientationMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int axesOrientationMode_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected final io.qt.sensors.QSensorBackend backend(){
        return backend_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sensors.QSensorBackend backend_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#bufferSize-prop">QSensor::bufferSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="bufferSize")
    @io.qt.QtUninvokable
    public final int bufferSize(){
        return bufferSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int bufferSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#connectToBackend">QSensor::connectToBackend()</a></p>
     */
    public final boolean connectToBackend(){
        return connectToBackend_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean connectToBackend_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#currentOrientation-prop">QSensor::currentOrientation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="currentOrientation")
    @io.qt.QtUninvokable
    public final int currentOrientation(){
        return currentOrientation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int currentOrientation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#dataRate-prop">QSensor::dataRate()const</a></p>
     */
    @io.qt.QtPropertyReader(name="dataRate")
    @io.qt.QtUninvokable
    public final int dataRate(){
        return dataRate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int dataRate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#description-prop">QSensor::description()const</a></p>
     */
    @io.qt.QtPropertyReader(name="description")
    @io.qt.QtUninvokable
    public final java.lang.String description(){
        return description_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String description_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#efficientBufferSize-prop">QSensor::efficientBufferSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="efficientBufferSize")
    @io.qt.QtUninvokable
    public final int efficientBufferSize(){
        return efficientBufferSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int efficientBufferSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#error-prop">QSensor::error()const</a></p>
     */
    @io.qt.QtPropertyReader(name="error")
    @io.qt.QtUninvokable
    public final int error(){
        return error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#filters">QSensor::filters()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.sensors.QSensorFilter> filters(){
        return filters_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.sensors.QSensorFilter> filters_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#identifier-prop">QSensor::identifier()const</a></p>
     */
    @io.qt.QtPropertyReader(name="identifier")
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray identifier(){
        return identifier_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray identifier_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#active-prop">QSensor::isActive()const</a></p>
     */
    @io.qt.QtPropertyReader(name="active")
    @io.qt.QtUninvokable
    public final boolean isActive(){
        return isActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#alwaysOn-prop">QSensor::isAlwaysOn()const</a></p>
     */
    @io.qt.QtPropertyReader(name="alwaysOn")
    @io.qt.QtUninvokable
    public final boolean isAlwaysOn(){
        return isAlwaysOn_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAlwaysOn_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#busy-prop">QSensor::isBusy()const</a></p>
     */
    @io.qt.QtPropertyReader(name="busy")
    @io.qt.QtUninvokable
    public final boolean isBusy(){
        return isBusy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isBusy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#connectedToBackend-prop">QSensor::isConnectedToBackend()const</a></p>
     */
    @io.qt.QtPropertyReader(name="connectedToBackend")
    @io.qt.QtUninvokable
    public final boolean isConnectedToBackend(){
        return isConnectedToBackend_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isConnectedToBackend_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#isFeatureSupported">QSensor::isFeatureSupported(QSensor::Feature)const</a></p>
     */
    public final boolean isFeatureSupported(io.qt.sensors.QSensor.Feature feature){
        return isFeatureSupported_native_QSensor_Feature_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), feature.value());
    }
    
    private native boolean isFeatureSupported_native_QSensor_Feature_constfct(long __this__nativeId, int feature);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#maxBufferSize-prop">QSensor::maxBufferSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxBufferSize")
    @io.qt.QtUninvokable
    public final int maxBufferSize(){
        return maxBufferSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxBufferSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#outputRange-prop">QSensor::outputRange()const</a></p>
     */
    @io.qt.QtPropertyReader(name="outputRange")
    @io.qt.QtUninvokable
    public final int outputRange(){
        return outputRange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int outputRange_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#outputRanges-prop">QSensor::outputRanges()const</a></p>
     */
    @io.qt.QtPropertyReader(name="outputRanges")
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.sensors.QOutputRange> outputRanges(){
        return outputRanges_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.sensors.QOutputRange> outputRanges_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#reading-prop">QSensor::reading()const</a></p>
     */
    @io.qt.QtPropertyReader(name="reading")
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public io.qt.sensors.QSensorReading reading(){
        return reading_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sensors.QSensorReading reading_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#removeFilter">QSensor::removeFilter(QSensorFilter*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeFilter(io.qt.sensors.QSensorFilter filter){
        removeFilter_native_QSensorFilter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(filter));
        if (filter != null) {
            while (__rcFilters != null && __rcFilters.remove(filter)) ;
        }
    }
    
    @io.qt.QtUninvokable
    private native void removeFilter_native_QSensorFilter_ptr(long __this__nativeId, long filter);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#active-prop">QSensor::setActive(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="active")
    @io.qt.QtUninvokable
    public final void setActive(boolean active){
        setActive_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), active);
    }
    
    @io.qt.QtUninvokable
    private native void setActive_native_bool(long __this__nativeId, boolean active);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#alwaysOn-prop">QSensor::setAlwaysOn(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="alwaysOn")
    @io.qt.QtUninvokable
    public final void setAlwaysOn(boolean alwaysOn){
        setAlwaysOn_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), alwaysOn);
    }
    
    @io.qt.QtUninvokable
    private native void setAlwaysOn_native_bool(long __this__nativeId, boolean alwaysOn);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#axesOrientationMode-prop">QSensor::setAxesOrientationMode(QSensor::AxesOrientationMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="axesOrientationMode")
    @io.qt.QtUninvokable
    public final void setAxesOrientationMode(io.qt.sensors.QSensor.AxesOrientationMode axesOrientationMode){
        setAxesOrientationMode_native_QSensor_AxesOrientationMode(QtJambi_LibraryUtilities.internal.nativeId(this), axesOrientationMode.value());
    }
    
    @io.qt.QtUninvokable
    private native void setAxesOrientationMode_native_QSensor_AxesOrientationMode(long __this__nativeId, int axesOrientationMode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#bufferSize-prop">QSensor::setBufferSize(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="bufferSize")
    @io.qt.QtUninvokable
    public final void setBufferSize(int bufferSize){
        setBufferSize_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), bufferSize);
    }
    
    @io.qt.QtUninvokable
    private native void setBufferSize_native_int(long __this__nativeId, int bufferSize);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#setCurrentOrientation">QSensor::setCurrentOrientation(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setCurrentOrientation(int currentOrientation){
        setCurrentOrientation_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), currentOrientation);
    }
    
    @io.qt.QtUninvokable
    private native void setCurrentOrientation_native_int(long __this__nativeId, int currentOrientation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#dataRate-prop">QSensor::setDataRate(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="dataRate")
    @io.qt.QtUninvokable
    public final void setDataRate(int rate){
        setDataRate_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), rate);
    }
    
    @io.qt.QtUninvokable
    private native void setDataRate_native_int(long __this__nativeId, int rate);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#setEfficientBufferSize">QSensor::setEfficientBufferSize(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setEfficientBufferSize(int efficientBufferSize){
        setEfficientBufferSize_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), efficientBufferSize);
    }
    
    @io.qt.QtUninvokable
    private native void setEfficientBufferSize_native_int(long __this__nativeId, int efficientBufferSize);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#identifier-prop">QSensor::setIdentifier(QByteArray)</a></p>
     */
    @io.qt.QtPropertyWriter(name="identifier")
    @io.qt.QtUninvokable
    public final void setIdentifier(io.qt.core.QByteArray identifier){
        setIdentifier_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(identifier));
    }
    
    @io.qt.QtUninvokable
    private native void setIdentifier_native_cref_QByteArray(long __this__nativeId, long identifier);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#setMaxBufferSize">QSensor::setMaxBufferSize(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMaxBufferSize(int maxBufferSize){
        setMaxBufferSize_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), maxBufferSize);
    }
    
    @io.qt.QtUninvokable
    private native void setMaxBufferSize_native_int(long __this__nativeId, int maxBufferSize);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#outputRange-prop">QSensor::setOutputRange(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="outputRange")
    @io.qt.QtUninvokable
    public final void setOutputRange(int index){
        setOutputRange_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @io.qt.QtUninvokable
    private native void setOutputRange_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#setSkipDuplicates">QSensor::setSkipDuplicates(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="skipDuplicates")
    @io.qt.QtUninvokable
    public final void setSkipDuplicates(boolean skipDuplicates){
        setSkipDuplicates_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), skipDuplicates);
    }
    
    @io.qt.QtUninvokable
    private native void setSkipDuplicates_native_bool(long __this__nativeId, boolean skipDuplicates);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#userOrientation-prop">QSensor::setUserOrientation(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="userOrientation")
    @io.qt.QtUninvokable
    public final void setUserOrientation(int userOrientation){
        setUserOrientation_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), userOrientation);
    }
    
    @io.qt.QtUninvokable
    private native void setUserOrientation_native_int(long __this__nativeId, int userOrientation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#skipDuplicates-prop">QSensor::skipDuplicates()const</a></p>
     */
    @io.qt.QtPropertyReader(name="skipDuplicates")
    @io.qt.QtUninvokable
    public final boolean skipDuplicates(){
        return skipDuplicates_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean skipDuplicates_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#start">QSensor::start()</a></p>
     */
    public final boolean start(){
        return start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean start_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#stop">QSensor::stop()</a></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#type-prop">QSensor::type()const</a></p>
     */
    @io.qt.QtPropertyReader(name="type")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray type(){
        return type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#userOrientation-prop">QSensor::userOrientation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="userOrientation")
    @io.qt.QtUninvokable
    public final int userOrientation(){
        return userOrientation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int userOrientation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#defaultSensorForType">QSensor::defaultSensorForType(QByteArray)</a></p>
     */
    public static io.qt.core.QByteArray defaultSensorForType(io.qt.core.QByteArray type){
        return defaultSensorForType_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.checkedNativeId(type));
    }
    
    private native static io.qt.core.QByteArray defaultSensorForType_native_cref_QByteArray(long type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#sensorTypes">QSensor::sensorTypes()</a></p>
     */
    public native static io.qt.core.QList<io.qt.core.QByteArray> sensorTypes();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#sensorsForType">QSensor::sensorsForType(QByteArray)</a></p>
     */
    public static io.qt.core.QList<io.qt.core.QByteArray> sensorsForType(io.qt.core.QByteArray type){
        return sensorsForType_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.checkedNativeId(type));
    }
    
    private native static io.qt.core.QList<io.qt.core.QByteArray> sensorsForType_native_cref_QByteArray(long type);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSensor(QPrivateConstructor p) { super(p); } 
    
}
