package io.qt.sensors;


/**
 * <p>Represents one reading from the rotation sensor</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qrotationreading.html">QRotationReading</a></p>
 */
public class QRotationReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRotationReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QRotationReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QRotationReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QRotationReading(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRotationReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>Sets the rotation from three euler angles</p>
     * <p>See <a href="https://doc.qt.io/qt/qrotationreading.html#setFromEuler">QRotationReading::setFromEuler(qreal,qreal,qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFromEuler(double x, double y, double z){
        setFromEuler_native_qreal_qreal_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void setFromEuler_native_qreal_qreal_qreal(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qrotationreading.html#x-prop">QRotationReading::x()const</a></p>
     */
    @io.qt.QtPropertyReader(name="x")
    @io.qt.QtUninvokable
    public final double x(){
        return x_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double x_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qrotationreading.html#y-prop">QRotationReading::y()const</a></p>
     */
    @io.qt.QtPropertyReader(name="y")
    @io.qt.QtUninvokable
    public final double y(){
        return y_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double y_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qrotationreading.html#z-prop">QRotationReading::z()const</a></p>
     */
    @io.qt.QtPropertyReader(name="z")
    @io.qt.QtUninvokable
    public final double z(){
        return z_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double z_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QRotationReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QRotationReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QRotationReading instance, QDeclarativeConstructor constructor);
    
}
