package io.qt.sensors;


/**
 * <p>Represents one reading from the ambient light sensor</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qambientlightreading.html">QAmbientLightReading</a></p>
 */
public class QAmbientLightReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAmbientLightReading.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qambientlightreading.html#LightLevel-enum">QAmbientLightReading::LightLevel</a></p>
     */
    public enum LightLevel implements io.qt.QtEnumerator {
        Undefined(0),
        Dark(1),
        Twilight(2),
        Light(3),
        Bright(4),
        Sunny(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private LightLevel(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static LightLevel resolve(int value) {
            switch (value) {
            case 0: return Undefined;
            case 1: return Dark;
            case 2: return Twilight;
            case 3: return Light;
            case 4: return Bright;
            case 5: return Sunny;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QAmbientLightReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAmbientLightReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QAmbientLightReading(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAmbientLightReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qambientlightreading.html#lightLevel-prop">QAmbientLightReading::lightLevel()const</a></p>
     */
    @io.qt.QtPropertyReader(name="lightLevel")
    @io.qt.QtUninvokable
    public final io.qt.sensors.QAmbientLightReading.LightLevel lightLevel(){
        return io.qt.sensors.QAmbientLightReading.LightLevel.resolve(lightLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int lightLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qambientlightreading.html#setLightLevel">QAmbientLightReading::setLightLevel(QAmbientLightReading::LightLevel)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setLightLevel(io.qt.sensors.QAmbientLightReading.LightLevel lightLevel){
        setLightLevel_native_QAmbientLightReading_LightLevel(QtJambi_LibraryUtilities.internal.nativeId(this), lightLevel.value());
    }
    
    @io.qt.QtUninvokable
    private native void setLightLevel_native_QAmbientLightReading_LightLevel(long __this__nativeId, int lightLevel);
    
    @io.qt.QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAmbientLightReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAmbientLightReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAmbientLightReading instance, QDeclarativeConstructor constructor);
    
}
