package io.qt.sensors;


/**
 * <p>Sensor implementation</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsensorbackend.html">QSensorBackend</a></p>
 */
public abstract class QSensorBackend extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSensorBackend.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QSensorBackend {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public void start(){
            start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void start_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void stop(){
            stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void stop_native(long __this__nativeId);
        
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QSensorBackend(io.qt.sensors.QSensor, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSensorBackend(io.qt.sensors.QSensor sensor) {
        this(sensor, (io.qt.core.QObject)null);
    }
    
    public QSensorBackend(io.qt.sensors.QSensor sensor, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, sensor, parent);
    }
    
    private native static void initialize_native(QSensorBackend instance, io.qt.sensors.QSensor sensor, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorbackend.html#addDataRate">QSensorBackend::addDataRate(qreal,qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addDataRate(double min, double max){
        addDataRate_native_qreal_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), min, max);
    }
    
    @io.qt.QtUninvokable
    private native void addDataRate_native_qreal_qreal(long __this__nativeId, double min, double max);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorbackend.html#addOutputRange">QSensorBackend::addOutputRange(qreal,qreal,qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addOutputRange(double min, double max, double accuracy){
        addOutputRange_native_qreal_qreal_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), min, max, accuracy);
    }
    
    @io.qt.QtUninvokable
    private native void addOutputRange_native_qreal_qreal_qreal(long __this__nativeId, double min, double max, double accuracy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorbackend.html#newReadingAvailable">QSensorBackend::newReadingAvailable()</a></p>
     */
    @io.qt.QtUninvokable
    public final void newReadingAvailable(){
        newReadingAvailable_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void newReadingAvailable_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorbackend.html#reading">QSensorBackend::reading()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sensors.QSensorReading reading(){
        return reading_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sensors.QSensorReading reading_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorbackend.html#sensor">QSensorBackend::sensor()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sensors.QSensor sensor(){
        return sensor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sensors.QSensor sensor_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #sensorBusy(boolean)}
     *  with <code>busy = true</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void sensorBusy() {
        sensorBusy((boolean)true);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorbackend.html#sensorBusy">QSensorBackend::sensorBusy(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void sensorBusy(boolean busy){
        sensorBusy_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), busy);
    }
    
    @io.qt.QtUninvokable
    private native void sensorBusy_native_bool(long __this__nativeId, boolean busy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorbackend.html#sensorError">QSensorBackend::sensorError(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void sensorError(int error){
        sensorError_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), error);
    }
    
    @io.qt.QtUninvokable
    private native void sensorError_native_int(long __this__nativeId, int error);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorbackend.html#sensorStopped">QSensorBackend::sensorStopped()</a></p>
     */
    @io.qt.QtUninvokable
    public final void sensorStopped(){
        sensorStopped_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void sensorStopped_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorbackend.html#setDataRates">QSensorBackend::setDataRates(const QSensor*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDataRates(io.qt.sensors.QSensor otherSensor){
        setDataRates_native_const_QSensor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(otherSensor));
    }
    
    @io.qt.QtUninvokable
    private native void setDataRates_native_const_QSensor_ptr(long __this__nativeId, long otherSensor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorbackend.html#setDescription">QSensorBackend::setDescription(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDescription(java.lang.String description){
        setDescription_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), description);
    }
    
    @io.qt.QtUninvokable
    private native void setDescription_native_cref_QString(long __this__nativeId, java.lang.String description);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorbackend.html#isFeatureSupported">QSensorBackend::isFeatureSupported(QSensor::Feature)const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isFeatureSupported(io.qt.sensors.QSensor.Feature feature){
        return isFeatureSupported_native_QSensor_Feature_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), feature.value());
    }
    
    @io.qt.QtUninvokable
    private native boolean isFeatureSupported_native_QSensor_Feature_constfct(long __this__nativeId, int feature);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorbackend.html#start">QSensorBackend::start()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void start();
    
    @io.qt.QtUninvokable
    private native void start_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorbackend.html#stop">QSensorBackend::stop()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void stop();
    
    @io.qt.QtUninvokable
    private native void stop_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSensorBackend(QPrivateConstructor p) { super(p); } 
    
}
