package io.qt.sensors;


/**
 * <p>Represents one reading from the light sensor</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qlightreading.html">QLightReading</a></p>
 */
public class QLightReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QLightReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QLightReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QLightReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QLightReading(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QLightReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qlightreading.html#lux-prop">QLightReading::lux()const</a></p>
     */
    @io.qt.QtPropertyReader(name="lux")
    @io.qt.QtUninvokable
    public final double lux(){
        return lux_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double lux_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qlightreading.html#setLux">QLightReading::setLux(qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setLux(double lux){
        setLux_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), lux);
    }
    
    @io.qt.QtUninvokable
    private native void setLux_native_qreal(long __this__nativeId, double lux);
    
    @io.qt.QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QLightReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QLightReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QLightReading instance, QDeclarativeConstructor constructor);
    
}
