package io.qt.sensors;


/**
 * <p>The pure virtual interface to sensor plugins</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsensorplugininterface.html">QSensorPluginInterface</a></p>
 */
public interface QSensorPluginInterface extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.sensors.QSensorPluginInterface}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.sensors.QSensorPluginInterface
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QSensorPluginInterface.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public void registerSensors(){
                registerSensors_native(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static void registerSensors_native(long __this__nativeId);
            
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QSensorPluginInterface instance);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsensorplugininterface.html#registerSensors">QSensorPluginInterface::registerSensors()</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void registerSensors();
        
        private native static void registerSensors_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorplugininterface.html#registerSensors">QSensorPluginInterface::registerSensors()</a></p>
     */
    @io.qt.QtUninvokable
    public void registerSensors();
    
}
