package io.qt.sensors;


/**
 * <p>Holds the readings from the sensor</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsensorreading.html">QSensorReading</a></p>
 */
public class QSensorReading extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSensorReading.class);
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorreading.html#setTimestamp">QSensorReading::setTimestamp(quint64)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTimestamp(long timestamp){
        setTimestamp_native_unsigned_long_long(QtJambi_LibraryUtilities.internal.nativeId(this), timestamp);
    }
    
    @io.qt.QtUninvokable
    private native void setTimestamp_native_unsigned_long_long(long __this__nativeId, long timestamp);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorreading.html#timestamp">QSensorReading::timestamp()const</a></p>
     */
    @io.qt.QtPropertyReader(name="timestamp")
    @io.qt.QtUninvokable
    public final long timestamp(){
        return timestamp_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native long timestamp_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorreading.html#value">QSensorReading::value(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object value(int index){
        return value_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object value_native_int_constfct(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorreading.html#valueCount">QSensorReading::valueCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int valueCount(){
        return valueCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int valueCount_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSensorReading(QPrivateConstructor p) { super(p); } 
    
}
