package io.qt.sensors;


/**
 * <p>Instantiates instances of QSensorBackend</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsensorbackendfactory.html">QSensorBackendFactory</a></p>
 */
public interface QSensorBackendFactory extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.sensors.QSensorBackendFactory}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.sensors.QSensorBackendFactory
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QSensorBackendFactory.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.sensors.QSensorBackend createBackend(io.qt.sensors.QSensor sensor){
                return createBackend_native_QSensor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sensor));
            }
            private native static io.qt.sensors.QSensorBackend createBackend_native_QSensor_ptr(long __this__nativeId, long sensor);
            
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QSensorBackendFactory instance);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsensorbackendfactory.html#createBackend">QSensorBackendFactory::createBackend(QSensor*)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract io.qt.sensors.QSensorBackend createBackend(io.qt.sensors.QSensor sensor);
        
        private native static io.qt.sensors.QSensorBackend createBackend_native_QSensor_ptr(long __this__nativeId, long sensor);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorbackendfactory.html#createBackend">QSensorBackendFactory::createBackend(QSensor*)</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.sensors.QSensorBackend createBackend(io.qt.sensors.QSensor sensor);
    
}
