package io.qt.sensors;


/**
 * <p>Holds the specifics of an output range</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qoutputrange.html">qoutputrange</a></p>
 */
public class QOutputRange extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    public QOutputRange(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOutputRange instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qoutputrange.html#accuracy-var">qoutputrange::accuracy</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAccuracy(double accuracy){
        setAccuracy_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), accuracy);
    }
    
    @io.qt.QtUninvokable
    private native void setAccuracy_native_qreal(long __this__nativeId, double accuracy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qoutputrange.html#accuracy-var">qoutputrange::accuracy</a></p>
     */
    @io.qt.QtUninvokable
    public final double accuracy(){
        return accuracy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double accuracy_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qoutputrange.html#maximum-var">qoutputrange::maximum</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMaximum(double maximum){
        setMaximum_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), maximum);
    }
    
    @io.qt.QtUninvokable
    private native void setMaximum_native_qreal(long __this__nativeId, double maximum);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qoutputrange.html#maximum-var">qoutputrange::maximum</a></p>
     */
    @io.qt.QtUninvokable
    public final double maximum(){
        return maximum_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double maximum_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qoutputrange.html#minimum-var">qoutputrange::minimum</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMinimum(double minimum){
        setMinimum_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), minimum);
    }
    
    @io.qt.QtUninvokable
    private native void setMinimum_native_qreal(long __this__nativeId, double minimum);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qoutputrange.html#minimum-var">qoutputrange::minimum</a></p>
     */
    @io.qt.QtUninvokable
    public final double minimum(){
        return minimum_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double minimum_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOutputRange(QPrivateConstructor p) { super(p); } 
    
    
    @Override
    public QOutputRange clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QOutputRange clone_native(long __this_nativeId);
}
