package io.qt.sensors;


/**
 * <p>Reports on linear acceleration along the X, Y and Z axes</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qaccelerometerreading.html">QAccelerometerReading</a></p>
 */
public class QAccelerometerReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAccelerometerReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAccelerometerReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAccelerometerReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QAccelerometerReading(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAccelerometerReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaccelerometerreading.html#setX">QAccelerometerReading::setX(qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setX(double x){
        setX_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), x);
    }
    
    @io.qt.QtUninvokable
    private native void setX_native_qreal(long __this__nativeId, double x);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaccelerometerreading.html#setY">QAccelerometerReading::setY(qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setY(double y){
        setY_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), y);
    }
    
    @io.qt.QtUninvokable
    private native void setY_native_qreal(long __this__nativeId, double y);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaccelerometerreading.html#setZ">QAccelerometerReading::setZ(qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setZ(double z){
        setZ_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), z);
    }
    
    @io.qt.QtUninvokable
    private native void setZ_native_qreal(long __this__nativeId, double z);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaccelerometerreading.html#x-prop">QAccelerometerReading::x()const</a></p>
     */
    @io.qt.QtPropertyReader(name="x")
    @io.qt.QtUninvokable
    public final double x(){
        return x_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double x_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaccelerometerreading.html#y-prop">QAccelerometerReading::y()const</a></p>
     */
    @io.qt.QtPropertyReader(name="y")
    @io.qt.QtUninvokable
    public final double y(){
        return y_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double y_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaccelerometerreading.html#z-prop">QAccelerometerReading::z()const</a></p>
     */
    @io.qt.QtPropertyReader(name="z")
    @io.qt.QtUninvokable
    public final double z(){
        return z_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double z_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAccelerometerReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAccelerometerReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAccelerometerReading instance, QDeclarativeConstructor constructor);
    
}
