package io.qt.sensors;


/**
 * <p>Holds readings from the pressure sensor</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qpressurereading.html">QPressureReading</a></p>
 */
public class QPressureReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPressureReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QPressureReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QPressureReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QPressureReading(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPressureReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpressurereading.html#pressure-prop">QPressureReading::pressure()const</a></p>
     */
    @io.qt.QtPropertyReader(name="pressure")
    @io.qt.QtUninvokable
    public final double pressure(){
        return pressure_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double pressure_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpressurereading.html#setPressure">QPressureReading::setPressure(qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPressure(double pressure){
        setPressure_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), pressure);
    }
    
    @io.qt.QtUninvokable
    private native void setPressure_native_qtjambireal(long __this__nativeId, double pressure);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpressurereading.html#setTemperature">QPressureReading::setTemperature(qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTemperature(double temperature){
        setTemperature_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), temperature);
    }
    
    @io.qt.QtUninvokable
    private native void setTemperature_native_qtjambireal(long __this__nativeId, double temperature);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpressurereading.html#temperature-prop">QPressureReading::temperature()const</a></p>
     */
    @io.qt.QtPropertyReader(name="temperature")
    @io.qt.QtUninvokable
    public final double temperature(){
        return temperature_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double temperature_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QPressureReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QPressureReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QPressureReading instance, QDeclarativeConstructor constructor);
    
}
