package io.qt.sensors;


/**
 * <p>Convenience wrapper around QSensor</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qaccelerometer.html">QAccelerometer</a></p>
 */
public class QAccelerometer extends io.qt.sensors.QSensor
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAccelerometer.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qaccelerometer.html#AccelerationMode-enum">QAccelerometer::AccelerationMode</a></p>
     */
    public enum AccelerationMode implements io.qt.QtEnumerator {
        Combined(0),
        Gravity(1),
        User(2);

        private AccelerationMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AccelerationMode resolve(int value) {
            switch (value) {
            case 0: return Combined;
            case 1: return Gravity;
            case 2: return User;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qaccelerometer.html#accelerationModeChanged">QAccelerometer::accelerationModeChanged(QAccelerometer::AccelerationMode)</a></p>
     */
    @io.qt.QtPropertyNotify(name="accelerationMode")
    public final Signal1<io.qt.sensors.QAccelerometer.AccelerationMode> accelerationModeChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAccelerometer(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAccelerometer() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaccelerometer.html#QAccelerometer">QAccelerometer::QAccelerometer(QObject*)</a></p>
     */
    public QAccelerometer(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAccelerometer instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaccelerometer.html#accelerationMode-prop">QAccelerometer::accelerationMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="accelerationMode")
    @io.qt.QtUninvokable
    public final io.qt.sensors.QAccelerometer.AccelerationMode accelerationMode(){
        return io.qt.sensors.QAccelerometer.AccelerationMode.resolve(accelerationMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int accelerationMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensor.html#reading-prop">QSensor::reading()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sensors.QAccelerometerReading reading(){
        return reading_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sensors.QAccelerometerReading reading_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaccelerometer.html#setAccelerationMode">QAccelerometer::setAccelerationMode(QAccelerometer::AccelerationMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="accelerationMode")
    @io.qt.QtUninvokable
    public final void setAccelerationMode(io.qt.sensors.QAccelerometer.AccelerationMode accelerationMode){
        setAccelerationMode_native_QAccelerometer_AccelerationMode(QtJambi_LibraryUtilities.internal.nativeId(this), accelerationMode.value());
    }
    
    @io.qt.QtUninvokable
    private native void setAccelerationMode_native_QAccelerometer_AccelerationMode(long __this__nativeId, int accelerationMode);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAccelerometer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAccelerometer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAccelerometer instance, QDeclarativeConstructor constructor);
    
}
