package io.qt.sensors;


/**
 * <p>The pure virtual interface to sensor plugins</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qsensorchangesinterface.html">QSensorChangesInterface</a></p>
 */
public interface QSensorChangesInterface extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.sensors.QSensorChangesInterface}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.sensors.QSensorChangesInterface
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QSensorChangesInterface.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public void sensorsChanged(){
                sensorsChanged_native(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static void sensorsChanged_native(long __this__nativeId);
            
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QSensorChangesInterface instance);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsensorchangesinterface.html#sensorsChanged">QSensorChangesInterface::sensorsChanged()</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void sensorsChanged();
        
        private native static void sensorsChanged_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsensorchangesinterface.html#sensorsChanged">QSensorChangesInterface::sensorsChanged()</a></p>
     */
    @io.qt.QtUninvokable
    public void sensorsChanged();
    
}
