package io.qt.sensors;


/**
 * <p>Holds readings from the humidity sensor</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qhumidityreading.html">QHumidityReading</a></p>
 */
public class QHumidityReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHumidityReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QHumidityReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QHumidityReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QHumidityReading(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QHumidityReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhumidityreading.html#absoluteHumidity-prop">QHumidityReading::absoluteHumidity()const</a></p>
     */
    @io.qt.QtPropertyReader(name="absoluteHumidity")
    @io.qt.QtUninvokable
    public final double absoluteHumidity(){
        return absoluteHumidity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double absoluteHumidity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhumidityreading.html#relativeHumidity-prop">QHumidityReading::relativeHumidity()const</a></p>
     */
    @io.qt.QtPropertyReader(name="relativeHumidity")
    @io.qt.QtUninvokable
    public final double relativeHumidity(){
        return relativeHumidity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double relativeHumidity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhumidityreading.html#setAbsoluteHumidity">QHumidityReading::setAbsoluteHumidity(qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAbsoluteHumidity(double value){
        setAbsoluteHumidity_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void setAbsoluteHumidity_native_qtjambireal(long __this__nativeId, double value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qhumidityreading.html#setRelativeHumidity">QHumidityReading::setRelativeHumidity(qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRelativeHumidity(double percent){
        setRelativeHumidity_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), percent);
    }
    
    @io.qt.QtUninvokable
    private native void setRelativeHumidity_native_qtjambireal(long __this__nativeId, double percent);
    
    @io.qt.QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QHumidityReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QHumidityReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QHumidityReading instance, QDeclarativeConstructor constructor);
    
}
