package io.qt.sensors;


/**
 * <p>Represents one reading from a compass</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qcompassreading.html">QCompassReading</a></p>
 */
public class QCompassReading extends io.qt.sensors.QSensorReading
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCompassReading.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QCompassReading(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCompassReading() {
        this((io.qt.core.QObject)null);
    }
    
    public QCompassReading(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QCompassReading instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcompassreading.html#azimuth-prop">QCompassReading::azimuth()const</a></p>
     */
    @io.qt.QtPropertyReader(name="azimuth")
    @io.qt.QtUninvokable
    public final double azimuth(){
        return azimuth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double azimuth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcompassreading.html#calibrationLevel-prop">QCompassReading::calibrationLevel()const</a></p>
     */
    @io.qt.QtPropertyReader(name="calibrationLevel")
    @io.qt.QtUninvokable
    public final double calibrationLevel(){
        return calibrationLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double calibrationLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcompassreading.html#setAzimuth">QCompassReading::setAzimuth(qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAzimuth(double azimuth){
        setAzimuth_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), azimuth);
    }
    
    @io.qt.QtUninvokable
    private native void setAzimuth_native_qtjambireal(long __this__nativeId, double azimuth);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qcompassreading.html#setCalibrationLevel">QCompassReading::setCalibrationLevel(qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setCalibrationLevel(double calibrationLevel){
        setCalibrationLevel_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), calibrationLevel);
    }
    
    @io.qt.QtUninvokable
    private native void setCalibrationLevel_native_qtjambireal(long __this__nativeId, double calibrationLevel);
    
    @io.qt.QtUninvokable
    protected void copyValuesFrom(io.qt.sensors.QSensorReading other){
        copyValuesFrom_native_QSensorReading_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void copyValuesFrom_native_QSensorReading_ptr(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QCompassReading(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QCompassReading(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QCompassReading instance, QDeclarativeConstructor constructor);
    
}
