package io.qt.sensors;

import io.qt.*;


/**
 * <p>The pure virtual interface to sensor plugins</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qsensorplugininterface.html">QSensorPluginInterface</a></p>
 */
public interface QSensorPluginInterface extends QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.sensors.QSensorPluginInterface}</p>
     */
    public static abstract class Impl extends QtObject
        implements io.qt.sensors.QSensorPluginInterface
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @NativeAccess
        private static final class ConcreteWrapper extends QSensorPluginInterface.Impl {
            
            @NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @QtUninvokable
            public void registerSensors(){
                registerSensors_native(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static void registerSensors_native(long __this__nativeId);
            
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QSensorPluginInterface instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsensorplugininterface.html#registerSensors">QSensorPluginInterface::registerSensors()</a></p>
         */
        @QtUninvokable
        public abstract void registerSensors();
        
        private native static void registerSensors_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensorplugininterface.html#registerSensors">QSensorPluginInterface::registerSensors()</a></p>
     */
    @QtUninvokable
    public void registerSensors();
    
}
