package io.qt.sensors;

import io.qt.*;


/**
 * <p>Handles registration and creation of sensor backends</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qsensormanager.html">QSensorManager</a></p>
 */
public class QSensorManager extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    
    public QSensorManager(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSensorManager instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensormanager.html#createBackend">QSensorManager::createBackend(QSensor*)</a></p>
     */
    public static io.qt.sensors.@Nullable QSensorBackend createBackend(io.qt.sensors.@Nullable QSensor sensor){
        return createBackend_native_QSensor_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(sensor));
    }
    
    private native static io.qt.sensors.QSensorBackend createBackend_native_QSensor_ptr(long sensor);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensormanager.html#isBackendRegistered">QSensorManager::isBackendRegistered(QByteArray,QByteArray)</a></p>
     */
    public static boolean isBackendRegistered(io.qt.core.@NonNull QByteArray type, io.qt.core.@NonNull QByteArray identifier){
        return isBackendRegistered_native_cref_QByteArray_cref_QByteArray(QtJambi_LibraryUtilities.internal.checkedNativeId(type), QtJambi_LibraryUtilities.internal.checkedNativeId(identifier));
    }
    
    private native static boolean isBackendRegistered_native_cref_QByteArray_cref_QByteArray(long type, long identifier);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensormanager.html#registerBackend">QSensorManager::registerBackend(QByteArray,QByteArray,QSensorBackendFactory*)</a></p>
     */
    public static void registerBackend(io.qt.core.@NonNull QByteArray type, io.qt.core.@NonNull QByteArray identifier, io.qt.sensors.@Nullable QSensorBackendFactory factory){
        io.qt.core.QPair<io.qt.core.QByteArray,io.qt.core.QByteArray> key = new io.qt.core.QPair<>(type, identifier);
        __rcBackends.put(key, factory);
        registerBackend_native_cref_QByteArray_cref_QByteArray_QSensorBackendFactory_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(type), QtJambi_LibraryUtilities.internal.checkedNativeId(identifier), QtJambi_LibraryUtilities.internal.checkedNativeId(factory));
    }
    
    private native static void registerBackend_native_cref_QByteArray_cref_QByteArray_QSensorBackendFactory_ptr(long type, long identifier, long factory);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensormanager.html#setDefaultBackend">QSensorManager::setDefaultBackend(QByteArray,QByteArray)</a></p>
     */
    public static void setDefaultBackend(io.qt.core.@NonNull QByteArray type, io.qt.core.@NonNull QByteArray identifier){
        setDefaultBackend_native_cref_QByteArray_cref_QByteArray(QtJambi_LibraryUtilities.internal.checkedNativeId(type), QtJambi_LibraryUtilities.internal.checkedNativeId(identifier));
    }
    
    private native static void setDefaultBackend_native_cref_QByteArray_cref_QByteArray(long type, long identifier);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsensormanager.html#unregisterBackend">QSensorManager::unregisterBackend(QByteArray,QByteArray)</a></p>
     */
    public static void unregisterBackend(io.qt.core.@NonNull QByteArray type, io.qt.core.@NonNull QByteArray identifier){
        io.qt.core.QPair<io.qt.core.QByteArray,io.qt.core.QByteArray> key = new io.qt.core.QPair<>(type, identifier);
        __rcBackends.remove(key);
        unregisterBackend_native_cref_QByteArray_cref_QByteArray(QtJambi_LibraryUtilities.internal.checkedNativeId(type), QtJambi_LibraryUtilities.internal.checkedNativeId(identifier));
    }
    
    private native static void unregisterBackend_native_cref_QByteArray_cref_QByteArray(long type, long identifier);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSensorManager(QPrivateConstructor p) { super(p); } 
    
    private final static java.util.Map<io.qt.core.QPair<io.qt.core.QByteArray,io.qt.core.QByteArray>,QSensorBackendFactory> __rcBackends = java.util.Collections.synchronizedMap(new java.util.HashMap<>());
}
